<?php

// =========================
// PUBLIC / AUTH
// =========================
$router->get('/', ['HomeController','index']);
$router->get('/login', ['AuthController','loginForm']);
$router->post('/login', ['AuthController','login']);
$router->get('/dashboard', ['AuthController','dashboard']);
$router->get('/logout', ['AuthController','logout']);

// =========================
// ESTUDIANTES
// =========================
$router->get('/estudiantes', ['EstudianteController','index']);
$router->get('/estudiantes/crear', ['EstudianteController','createForm']);
$router->post('/estudiantes/crear', ['EstudianteController','store']);
$router->get('/estudiantes/editar', ['EstudianteController','editForm']);
$router->post('/estudiantes/editar', ['EstudianteController','update']);
$router->post('/estudiantes/eliminar', ['EstudianteController','destroy']);

// =========================
// PREGUNTAS (DOCENTE/ADMIN)
// =========================
$router->get('/preguntas', ['PreguntaController','index']);
$router->get('/preguntas/crear', ['PreguntaController','createForm']);
$router->post('/preguntas/crear', ['PreguntaController','store']);
$router->get('/preguntas/editar', ['PreguntaController','editForm']);     // ?id=1
$router->post('/preguntas/editar', ['PreguntaController','update']);      // POST
$router->post('/preguntas/eliminar', ['PreguntaController','destroy']);   // POST
$router->get('/preguntas/curso', ['PreguntaController','byCurso']);       // ?id=CURSO

// =========================
// CURSOS (DOCENTE)
// =========================
$router->get('/cursos', ['CursoController','index']);
$router->get('/cursos/crear', ['CursoController','createForm']);
$router->post('/cursos/crear', ['CursoController','store']);
$router->get('/cursos/editar', ['CursoController','editForm']);           // ?id=...
$router->post('/cursos/editar', ['CursoController','update']);
$router->post('/cursos/eliminar', ['CursoController','destroy']);
$router->post('/cursos/estado', ['CursoController','toggleEstado']);
$router->get('/cursos/entrar', ['CursoController','entrar']);             // ?id=CURSO

// =========================
// PARTIDAS (FASE 3 PRO)
// =========================
$router->get('/partidas', ['PartidaController','index']);
$router->get('/partidas/crear', ['PartidaController','createForm']);
$router->post('/partidas/crear', ['PartidaController','store']);

$router->get('/partidas/editar', ['PartidaController','editForm']);       // ?id=...
$router->post('/partidas/editar', ['PartidaController','update']);        // POST
$router->post('/partidas/eliminar', ['PartidaController','destroy']);     // POST

$router->get('/partidas/preguntas', ['PartidaController','preguntasForm']);   // ?id=PARTIDA
$router->post('/partidas/preguntas', ['PartidaController','preguntasSave']);  // POST

$router->post('/partidas/iniciar', ['PartidaController','iniciar']);
$router->post('/partidas/finalizar', ['PartidaController','finalizar']);
$router->get('/partidas/ranking', ['PartidaController','ranking']);           // ?id=...

// =========================
// PARTICIPACION / QUIZ
// =========================
$router->get('/unirse', ['ParticipacionController','unirseForm']);
$router->post('/unirse', ['ParticipacionController','unirse']);
$router->get('/sala', ['ParticipacionController','sala']);
$router->get('/sala/estado', ['ParticipacionController','estado']);

$router->get('/quiz', ['QuizController','show']);
$router->post('/quiz/responder', ['QuizController','responder']);
$router->post('/quiz/enviar', ['QuizController','enviar']);
$router->get('/quiz/fin', ['QuizController','fin']);

$router->get('/resultado', ['ResultadoController','show']);
$router->get('/mis-resultados', ['ResultadoController','misResultados']);

// =========================
// ADMIN
// =========================
$router->get('/admin/docentes', ['AdminDocenteController','index']);
$router->get('/admin/docentes/crear', ['AdminDocenteController','createForm']);
$router->post('/admin/docentes/crear', ['AdminDocenteController','store']);
$router->get('/admin/docentes/editar', ['AdminDocenteController','editForm']);
$router->post('/admin/docentes/editar', ['AdminDocenteController','update']);
$router->post('/admin/docentes/estado', ['AdminDocenteController','toggleEstado']);
$router->post('/admin/docentes/reset', ['AdminDocenteController','resetPassword']);
$router->post('/admin/docentes/eliminar', ['AdminDocenteController','destroy']);

$router->get('/admin/computadoras', ['AdminComputadoraController','index']);
$router->post('/admin/computadoras/crear', ['AdminComputadoraController','create']);
$router->get('/admin/computadoras/editar', ['AdminComputadoraController','editForm']);
$router->post('/admin/computadoras/editar', ['AdminComputadoraController','update']);
$router->post('/admin/computadoras/eliminar', ['AdminComputadoraController','delete']);

$router->get('/admin/config', ['AdminConfigController','index']);
$router->post('/admin/config/guardar', ['AdminConfigController','save']);

// ✅ CONTROL EN VIVO (FASE 5)
$router->get('/partidas/control', ['PartidaController','control']);          // ?id=PARTIDA
$router->get('/partidas/control/data', ['PartidaController','controlData']); // ?id=PARTIDA  (JSON)
