/* ==========================================
   SEIR UI (Global)
   Archivo: public/assets/js/seir-ui.js

   Incluye:
   1) Toasts
   2) Confirmaciones con data-confirm
   3) Autofocus con data-autofocus
   4) Login: rotador de frases
   5) Login: rotador de IMÁGENES (lado derecho)
   ========================================== */

(function () {
  // ===============================
  // 1) TOASTS
  // ===============================
  function ensureToastContainer() {
    let wrap = document.getElementById("seir-toast-wrap");
    if (wrap) return wrap;

    wrap = document.createElement("div");
    wrap.id = "seir-toast-wrap";
    wrap.className = "toast-container position-fixed top-0 end-0 p-3";
    wrap.style.zIndex = 2000;
    document.body.appendChild(wrap);
    return wrap;
  }

  // window.SEIRToast("Mensaje", "success|danger|warning|info")
  window.SEIRToast = function (message, type = "info") {
    const wrap = ensureToastContainer();

    const icon =
      type === "success" ? "bi-check-circle-fill" :
      type === "danger" ? "bi-x-octagon-fill" :
      type === "warning" ? "bi-exclamation-triangle-fill" :
      "bi-info-circle-fill";

    const header =
      type === "success" ? "Listo" :
      type === "danger" ? "Error" :
      type === "warning" ? "Atención" :
      "Aviso";

    const toast = document.createElement("div");
    toast.className = "toast align-items-center text-bg-light border-0 shadow";
    toast.setAttribute("role", "alert");
    toast.setAttribute("aria-live", "assertive");
    toast.setAttribute("aria-atomic", "true");

    toast.innerHTML = `
      <div class="d-flex">
        <div class="toast-body">
          <div class="d-flex align-items-center gap-2">
            <i class="bi ${icon}"></i>
            <div>
              <div style="font-weight:900">${header}</div>
              <div style="opacity:.8; font-size:.92rem">${message}</div>
            </div>
          </div>
        </div>
        <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Cerrar"></button>
      </div>
    `;

    wrap.appendChild(toast);
    const bsToast = new bootstrap.Toast(toast, { delay: 3200 });
    bsToast.show();

    toast.addEventListener("hidden.bs.toast", () => toast.remove());
  };

  // ===============================
  // 2) DOM READY
  // ===============================
  document.addEventListener("DOMContentLoaded", () => {

    // 2.1) Confirmaciones (usar: data-confirm="¿Seguro?")
    document.body.addEventListener("click", (e) => {
      const btn = e.target.closest("[data-confirm]");
      if (!btn) return;

      const msg = btn.getAttribute("data-confirm") || "¿Confirmar acción?";
      const ok = window.confirm(msg);
      if (!ok) {
        e.preventDefault();
        e.stopPropagation();
      }
    });

    // 2.2) Autofocus elegante: primer input con data-autofocus
    const af = document.querySelector("[data-autofocus]");
    if (af) af.focus();

    // ===============================
    // 3) LOGIN: ROTADOR DE FRASES
    // ===============================
    (function(){
      const msgs = document.querySelectorAll('.login-messages .msg');
      if (!msgs.length) return;

      let i = 0;

      // activa el primero si no hay ninguno active
      if (![...msgs].some(m => m.classList.contains("active"))) {
        msgs[0].classList.add("active");
      }

      setInterval(() => {
        msgs.forEach(m => m.classList.remove('active'));
        msgs[i].classList.add('active');
        i = (i + 1) % msgs.length;
      }, 3000);
    })();

    // ===============================
    // 4) LOGIN: ROTADOR DE IMÁGENES (lado derecho)
    //    Requiere en CSS:
    //    .seir-login-right::before { background-image: var(--loginBg); }
    // ===============================
    (function(){
      const right = document.querySelector('.seir-login-right');
      if (!right) return;

      // ✅ tus archivos reales (según tu carpeta)
      const imgs = [
        "/SEIR/public/assets/img/login_1.png",
        "/SEIR/public/assets/img/login_2.png",
        "/SEIR/public/assets/img/login_3.png",
        "/SEIR/public/assets/img/login_4.png",
      ];

      let idx = 0;

      function setBg(url){
        right.style.setProperty('--loginBg', `url("${url}")`);
      }

      // primera
      setBg(imgs[idx]);

      // cambia cada 5s
      setInterval(() => {
        idx = (idx + 1) % imgs.length;
        setBg(imgs[idx]);
      }, 5000);
    })();

  });
})();
