<div class="seir-page">
  <div class="seir-hero d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <h3>Resultados</h3>
      <p>Partida: <strong><?= htmlspecialchars($quiz['titulo']) ?></strong> • Alias: <strong><?= htmlspecialchars($quiz['alias']) ?></strong></p>
    </div>
    <span class="badge-soft"><i class="bi bi-trophy-fill"></i> Ranking</span>
  </div>

  <div class="seir-body">
    <div class="table-card">
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th style="width:70px;">N°</th>
              <th>Alias</th>
              <th>Nombre</th>
              <th class="text-end">Puntaje</th>
              <th class="text-end">Respuestas</th>
            </tr>
          </thead>
          <tbody>
            <?php $n=1; foreach ($ranking as $r): ?>
              <?php $esYo = (($r['alias'] ?? '') === ($quiz['alias'] ?? '')); ?>
              <tr class="<?= $esYo ? 'row-me' : '' ?>">
                <td><?= $n++ ?></td>
                <td><?= htmlspecialchars($r['alias']) ?></td>
                <td><?= htmlspecialchars(($r['nombres'] ?? '').' '.($r['apellidos'] ?? '')) ?></td>
                <td class="text-end fw-semibold"><?= htmlspecialchars($r['puntaje_total']) ?></td>
                <td class="text-end"><?= htmlspecialchars($r['respuestas']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-outline-secondary" href="/SEIR/public/sala">
        <i class="bi bi-arrow-left me-1"></i> Volver
      </a>
      <a class="btn btn-outline-dark" href="/SEIR/public/dashboard">
        <i class="bi bi-grid me-1"></i> Dashboard
      </a>
    </div>
  </div>
</div>
