<div class="seir-page">
  <div class="seir-hero d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <h3>Mis resultados</h3>
      <p>Historial por partida (puntaje total y ranking logrado).</p>
    </div>
    <a class="btn btn-outline-light" href="/SEIR/public/dashboard">
      <i class="bi bi-arrow-left"></i> Menú
    </a>
  </div>

  <div class="seir-body">
    <?php if (empty($rows)): ?>
      <div class="alert alert-info mb-0">Aún no tienes resultados registrados.</div>
    <?php else: ?>
      <div class="table-card">
        <div class="table-responsive">
          <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>Partida</th>
                <th class="text-end">Puntaje total</th>
                <th>Fecha</th>
                <th class="text-end">Ranking</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td class="fw-semibold"><?= htmlspecialchars($r['partida'] ?? '') ?></td>
                  <td class="text-end fw-bold"><?= (int)($r['puntaje_total'] ?? 0) ?> pts</td>
                  <td><?= htmlspecialchars($r['fecha'] ?? '') ?></td>
                  <td class="text-end">
                    <span class="badge bg-primary rounded-pill">
                      <?= htmlspecialchars($r['ranking_logrado'] ?? '-') ?>
                    </span>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    <?php endif; ?>
  </div>
</div>
