<?php
// app/views/resultado/docente.php
// Variables: $rows (array), $user (array)
?>

<div class="puntajes-page">
  <div class="seir-card">
    <div class="seir-card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
      <div>
        <h4 class="seir-title mb-0">
          <i class="bi bi-bar-chart-line me-2"></i>Puntajes por partida
        </h4>
        <div class="seir-sub">Resumen de rendimiento y acceso rápido al ranking.</div>
      </div>

      <div class="d-flex flex-wrap gap-2">
        <a class="btn btn-outline-dark" href="/SEIR/public/dashboard">
          <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
      </div>
    </div>

    <div class="seir-card-body">

      <?php if (empty($rows)): ?>
        <div class="seir-empty">
          <div class="seir-empty-icon"><i class="bi bi-clipboard-data"></i></div>
          <div class="seir-empty-title">Aún no hay partidas registradas</div>
          <div class="seir-empty-sub">Crea una partida y aquí verás los puntajes y accesos al ranking.</div>
          <div class="mt-3">
            <a class="btn btn-seir" href="/SEIR/public/partidas/crear">
              <i class="bi bi-plus-circle me-1"></i>Nueva partida
            </a>
          </div>
        </div>
      <?php else: ?>

        <div class="seir-tools d-flex flex-column flex-lg-row gap-2 justify-content-between align-items-start align-items-lg-center mb-3">
          <div class="input-group seir-search">
            <span class="input-group-text"><i class="bi bi-search"></i></span>
            <input id="q" type="text" class="form-control" placeholder="Buscar por código, título, estado...">
            <button id="clear" class="btn btn-outline-secondary" type="button">Limpiar</button>
          </div>

          <div class="seir-total">
            Total: <strong id="count"><?= count($rows) ?></strong>
          </div>
        </div>

        <div class="seir-table-wrap">
          <table id="tbl" class="seir-table">
            <thead>
              <tr>
                <th>Código</th>
                <th>Título</th>
                <th class="col-center">Estado</th>
                <th class="col-center">Participantes</th>
                <th class="col-center">Respuestas</th>
                <th class="col-center">% Acierto</th>
                <th class="col-center">Creado</th>
                <th class="text-end">Acción</th>
              </tr>
            </thead>

            <tbody>
            <?php foreach ($rows as $r): ?>
              <?php
                $estado = strtoupper(trim((string)($r['estado'] ?? '')));
                $tagClass = 'tag-soft';
                if ($estado === 'CREADA') $tagClass = 'tag-soft';
                if ($estado === 'EN_CURSO') $tagClass = 'tag-mid';
                if ($estado === 'FINALIZADA') $tagClass = 'tag-ok';

                $created = (string)($r['created_at'] ?? '');
                $fecha = $created;
                $hora = '';
                if (strpos($created, ' ') !== false) {
                  [$fecha, $hora] = explode(' ', $created, 2);
                }

                $porc = $r['porcentaje'];
                $porcTxt = ($porc === null || $porc === '' ) ? '—' : (rtrim(rtrim((string)$porc,'0'),'.') . '%');
              ?>
              <tr>
                <td><span class="code-pill"><?= htmlspecialchars((string)($r['codigo'] ?? '')) ?></span></td>

                <td>
                  <div class="title-cell">
                    <div class="title-main"><?= htmlspecialchars((string)($r['titulo'] ?? '')) ?></div>
                    <div class="title-sub">ID: <?= (int)($r['id_partida'] ?? 0) ?></div>
                  </div>
                </td>

                <td class="col-center">
                  <span class="tag <?= $tagClass ?>"><?= htmlspecialchars($estado ?: '-') ?></span>
                </td>

                <td class="col-center">
                  <span class="metric-pill">
                    <i class="bi bi-people-fill"></i>
                    <?= (int)($r['participantes'] ?? 0) ?>
                  </span>
                </td>

                <td class="col-center">
                  <span class="metric-pill">
                    <i class="bi bi-ui-checks"></i>
                    <?= (int)($r['respuestas'] ?? 0) ?>
                  </span>
                </td>

                <td class="col-center">
                  <span class="percent-pill"><?= htmlspecialchars($porcTxt) ?></span>
                </td>

                <td class="col-center">
                  <div class="created-cell">
                    <div class="created-date"><?= htmlspecialchars($fecha) ?></div>
                    <?php if (!empty($hora)): ?>
                      <div class="created-time"><?= htmlspecialchars($hora) ?></div>
                    <?php endif; ?>
                  </div>
                </td>

                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary"
                     href="/SEIR/public/partidas/ranking?id=<?= (int)($r['id_partida'] ?? 0) ?>">
                    <i class="bi bi-trophy me-1"></i>Ranking
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>

          </table>
        </div>

      <?php endif; ?>
    </div>
  </div>
</div>

<script>
  // Buscador frontend para puntajes
  const q = document.getElementById('q');
  const clear = document.getElementById('clear');
  const tbl = document.getElementById('tbl');
  const count = document.getElementById('count');

  function filterRows(){
    if (!tbl) return;
    const term = (q?.value || '').toLowerCase().trim();
    const rows = Array.from(tbl.querySelectorAll('tbody tr'));
    let visible = 0;

    rows.forEach(r => {
      const text = r.innerText.toLowerCase();
      const show = text.includes(term);
      r.style.display = show ? '' : 'none';
      if (show) visible++;
    });

    if (count) count.textContent = visible;
  }

  q?.addEventListener('input', filterRows);
  clear?.addEventListener('click', () => { q.value=''; filterRows(); q.focus(); });
</script>
