<?php if (!empty($preg['imagen'])): ?>
  <div class="quiz-img mb-3 text-center">
    <img src="/SEIR/public/assets/uploads/preguntas/<?= htmlspecialchars($preg['imagen']) ?>"
         style="max-width:100%;border-radius:16px">
  </div>
<?php endif; ?>


<div class="seir-page">
  <div class="seir-hero d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <h3><?= htmlspecialchars($quiz['titulo'] ?? 'Examen') ?></h3>
      <p>Alias: <strong><?= htmlspecialchars($quiz['alias'] ?? '') ?></strong></p>
    </div>

    <div class="soft-card px-3 py-2">
      <div class="small" style="opacity:.85;">Tiempo restante</div>
      <div class="h4 m-0 timer" id="timer">--:--</div>
    </div>
  </div>

  <div class="seir-body">
    <div class="quiz-grid">
      <!-- Pregunta -->
      <div class="quiz-card p-3 p-md-4">
        <div class="d-flex justify-content-between align-items-center gap-3 mb-2">
          <div class="fw-black" style="font-weight:900;">
            Pregunta <?= (int)$orden ?> de <?= (int)$total ?>
          </div>
          <div class="text-muted">
            Respondidas: <strong><?= (int)$respondidas ?></strong> / <?= (int)$total ?>
          </div>
        </div>
      
        <div class="fs-5 mb-3" style="color:#334155;">
          <?= htmlspecialchars($preg['enunciado'] ?? '') ?>
        </div>

        <form method="POST" action="/SEIR/public/quiz/responder" id="frm">
          <input type="hidden" name="id_partida_pregunta" value="<?= (int)$preg['id_partida_pregunta'] ?>">
          <input type="hidden" name="orden" value="<?= (int)$orden ?>">
          <input type="hidden" name="tiempo" id="tiempo" value="0">

          <div class="d-grid gap-2">
            <?php foreach ($alts as $a): ?>
              <?php $idAlt = (int)$a['id_alternativa']; ?>
              <label class="opt">
                <input type="radio" name="id_alternativa" value="<?= $idAlt ?>" <?= ($seleccionada === $idAlt) ? 'checked' : '' ?>>
                <div>
                  <div class="fw-semibold"><?= htmlspecialchars($a['texto']) ?></div>
                </div>
              </label>
            <?php endforeach; ?>
          </div>

          <div class="d-flex flex-column flex-md-row gap-2 mt-3">
            <button class="btn btn-seir" type="submit">
              <i class="bi bi-check2-circle me-1"></i> Guardar respuesta
            </button>

            <div class="ms-md-auto d-flex gap-2 flex-wrap">
              <?php if ($orden > 1): ?>
                <a class="btn btn-outline-secondary" href="/SEIR/public/quiz?o=<?= (int)($orden-1) ?>">← Anterior</a>
              <?php endif; ?>
              <?php if ($orden < $total): ?>
                <a class="btn btn-outline-secondary" href="/SEIR/public/quiz?o=<?= (int)($orden+1) ?>">Siguiente →</a>
              <?php endif; ?>
              <button class="btn btn-success" type="button" onclick="enviarExamen()">
                <i class="bi bi-send-check me-1"></i> Enviar examen
              </button>
            </div>
          </div>
        </form>
      </div>

      <!-- Navegación -->
      <div class="quiz-card p-3 p-md-4">
        <div class="fw-bold mb-2">Navegación</div>
        <div class="grid-nav">
          <?php foreach ($preguntas as $pp): ?>
            <?php
              $o = (int)$pp['orden'];
              $idpp = (int)$pp['id_partida_pregunta'];
              $cls = 'nbtn';
              if ($o === (int)$orden) $cls .= ' curr';
              if (isset($mapResp[$idpp])) $cls .= ' ans';
            ?>
            <a class="<?= $cls ?>" href="/SEIR/public/quiz?o=<?= $o ?>"><?= $o ?></a>
          <?php endforeach; ?>
        </div>

        <hr>

        <div class="small text-muted">
          <div><span class="badge bg-success-subtle text-success border">Respondida</span></div>
          <div class="mt-1"><span class="badge bg-primary-subtle text-primary border">Actual</span></div>
        </div>
      </div>
    </div>
  </div>
</div>

<form method="POST" action="/SEIR/public/quiz/enviar" id="frmEnviar"></form>

<script>
  let seg = <?= (int)$segRest ?>;
  const el = document.getElementById('timer');
  const tHidden = document.getElementById('tiempo');

  function fmt(s){
    const m = Math.floor(s/60);
    const ss = s%60;
    return String(m).padStart(2,'0') + ':' + String(ss).padStart(2,'0');
  }

  function tick(){
    if (seg <= 0){
      window.location.href = '/SEIR/public/quiz/fin';
      return;
    }
    el.textContent = fmt(seg);
    tHidden.value = String(seg);
    seg--;
  }
  tick();
  setInterval(tick, 1000);

  function enviarExamen(){
    if (!confirm('¿Seguro que deseas enviar el examen?\nLuego ya no podrás editar tus respuestas.')) return;
    document.getElementById('frmEnviar').submit();
  }
</script>
