<div class="seir-preguntas">
  <div class="page-shell">

    <div class="page-head">
      <div>
        <h2 class="title">Banco de preguntas</h2>
        <p class="subtitle">Administra tus preguntas para evaluaciones interactivas.</p>
      </div>
    </div>

    <?php if (!empty($ok)): ?>
      <div class="seir-alert ok"><?= htmlspecialchars($ok) ?></div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
      <div class="seir-alert err"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="seir-toolbar">
      <a class="seir-btn primary" href="/SEIR/public/preguntas/crear">+ Nueva pregunta</a>
      <a class="seir-btn light" href="/SEIR/public/dashboard">Volver</a>
    </div>

    <div class="seir-card">
      <div class="seir-table-wrap">
        <table class="seir-table">
          <thead>
            <tr>
              <th>N°</th>
              <th>ID</th>
              <th>Enunciado</th>
              <th>Dificultad</th>
              <th>Grado</th>
              <th>Activo</th>
              <th>Creado</th>
              <th>Acciones</th>
            </tr>
          </thead>

          <tbody>
          <?php $n = 1; ?>
          <?php foreach ($preguntas as $p): ?>
            <?php
              $dif = strtoupper((string)($p['dificultad'] ?? ''));
              $difClass = 'dif-media';
              if ($dif === 'FACIL') $difClass = 'dif-facil';
              if ($dif === 'DIFICIL') $difClass = 'dif-dificil';
            ?>
            <tr>
              <td><?= $n++ ?></td>
              <td><?= (int)$p['id_pregunta'] ?></td>
              <td><?= htmlspecialchars(mb_strimwidth($p['enunciado'], 0, 90, '...')) ?></td>

              <td>
                <span class="badge <?= $difClass ?>">
                  <?= htmlspecialchars($dif) ?>
                </span>
              </td>

              <td><?= htmlspecialchars($p['grado'] ?? 'TODOS') ?></td>

              <td>
                <span class="badge <?= $p['activo'] ? 'activo' : 'inactivo' ?>">
                  <?= $p['activo'] ? 'Sí' : 'No' ?>
                </span>
              </td>

              <td><?= htmlspecialchars($p['created_at']) ?></td>

              <td>
                <div class="row-actions">
                  <a class="seir-link edit" href="/SEIR/public/preguntas/editar?id=<?= (int)$p['id_pregunta'] ?>">
                    Editar
                  </a>

                  <form method="POST" action="/SEIR/public/preguntas/eliminar"
                        onsubmit="return confirm('¿Seguro que deseas eliminar esta pregunta?');">
                    <input type="hidden" name="id_pregunta" value="<?= (int)$p['id_pregunta'] ?>">
                    <button class="seir-link del" type="submit">Eliminar</button>
                  </form>
                </div>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>

        </table>
      </div>
    </div>

  </div>
</div>
