<div class="seir-preguntas">
  <div class="page-shell">

    <div class="page-head">
      <div>
        <h2 class="title">Editar pregunta</h2>
        <p class="subtitle">Actualiza enunciado, imagen y alternativas.</p>
      </div>
    </div>

    <?php if (!empty($error)): ?>
      <div class="seir-alert err"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="seir-card">
      <form method="POST"
            action="/SEIR/public/preguntas/editar"
            enctype="multipart/form-data"
            class="seir-form">

        <input type="hidden" name="id_pregunta" value="<?= (int)$p['id_pregunta'] ?>">

        <div class="form-grid">
          <div class="form-group">
            <label>Enunciado</label>
            <textarea name="enunciado" required class="textarea"><?= htmlspecialchars($p['enunciado']) ?></textarea>
          </div>

          <div>
            <div class="form-group">
              <label>Dificultad</label>
              <select name="dificultad" class="select">
                <?php foreach (['FACIL','MEDIA','DIFICIL'] as $d): ?>
                  <option value="<?= $d ?>" <?= $p['dificultad']===$d?'selected':'' ?>><?= $d ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="form-group">
              <label>Grado</label>
              <select name="grado" class="select">
                <?php foreach (['TODOS','1','2','3','4','5'] as $g): ?>
                  <option value="<?= $g ?>" <?= ($p['grado']??'TODOS')===$g?'selected':'' ?>><?= $g ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <!-- Imagen actual -->
            <?php if (!empty($p['imagen'])): ?>
              <div class="form-group">
                <label>Imagen actual</label>
                <img src="/SEIR/public/assets/uploads/preguntas/<?= htmlspecialchars($p['imagen']) ?>"
                     style="max-width:100%;border-radius:12px">
              </div>
            <?php endif; ?>

            <div class="form-group">
              <label>Cambiar imagen</label>
              <input type="file" name="imagen" accept="image/*" class="input">
            </div>

            <div class="checkline">
              <input type="checkbox" name="activo" <?= ((int)$p['activo']===1?'checked':'') ?>>
              <strong>Activo</strong>
            </div>
          </div>
        </div>

        <hr class="divider">

        <h3 class="section-title">Alternativas</h3>

        <?php
          $labels = ['A','B','C','D'];
          $slots = array_fill(0,4,'');
          $correct = 0;
          foreach ($alts as $i=>$a){
            $slots[$i] = $a['texto'];
            if ($a['es_correcta']) $correct = $i;
          }
        ?>

        <div class="alts">
          <?php for ($i=0; $i<4; $i++): ?>
            <div class="alt-row">
              <div class="alt-pill"><?= $labels[$i] ?></div>
              <div class="alt-radio">
                <input type="radio" name="correcta" value="<?= $i ?>" <?= $i===$correct?'checked':'' ?>>
              </div>
              <input type="text" name="alt[<?= $i ?>]"
                     class="input"
                     value="<?= htmlspecialchars($slots[$i]) ?>"
                     <?= $i<2?'required':'' ?>>
            </div>
          <?php endfor; ?>
        </div>

        <div class="actions">
          <button class="seir-btn primary">Guardar cambios</button>
          <a class="seir-btn light" href="/SEIR/public/preguntas">Cancelar</a>
        </div>
      </form>
    </div>

  </div>
</div>
