<div class="seir-preguntas">
  <div class="page-shell">

    <div class="page-head">
      <div>
        <h2 class="title">Nueva pregunta</h2>
        <p class="subtitle">Crea preguntas para tu banco y úsalas en partidas.</p>
      </div>
    </div>

    <?php if (!empty($error)): ?>
      <div class="seir-alert err"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="seir-card">
      <form method="POST"
            action="/SEIR/public/preguntas/crear"
            enctype="multipart/form-data"
            class="seir-form">
        <?php if (!empty($idCurso) && (int)$idCurso > 0): ?>
        <input type="hidden" name="id_curso" value="<?= (int)$idCurso ?>">
        <?php endif; ?>

        <div class="form-grid">
          <div class="form-group">
            <label>Enunciado</label>
            <textarea name="enunciado" required class="textarea"
              placeholder="Escribe la pregunta..."></textarea>
          </div>

          <div>
            <div class="form-group">
              <label>Dificultad</label>
              <select name="dificultad" class="select">
                <option value="FACIL">FÁCIL</option>
                <option value="MEDIA">MEDIA</option>
                <option value="DIFICIL">DIFÍCIL</option>
              </select>
            </div>

            <div class="form-group">
              <label>Grado</label>
              <select name="grado" class="select">
                <option value="TODOS" selected>Todos</option>
                <option value="1">1°</option>
                <option value="2">2°</option>
                <option value="3">3°</option>
                <option value="4">4°</option>
                <option value="5">5°</option>
              </select>
            </div>

            <!-- 🖼 Imagen -->
            <div class="form-group">
              <label>Imagen (opcional)</label>
              <input type="file" name="imagen" accept="image/*" class="input">
              <div class="helper">JPG, PNG o WEBP · máx 2MB</div>
            </div>
          </div>
        </div>

        <hr class="divider">

        <h3 class="section-title">Alternativas</h3>

        <div class="alts">
          <?php $labels = ['A','B','C','D']; ?>
          <?php for ($i=0; $i<4; $i++): ?>
            <div class="alt-row">
              <div class="alt-pill"><?= $labels[$i] ?></div>
              <div class="alt-radio">
                <input type="radio" name="correcta" value="<?= $i ?>" required>
              </div>
              <input type="text"
              name="alt[<?= $i ?>]"
              class="input"
              placeholder="Alternativa <?= $labels[$i] ?>"
              required>

            </div>
          <?php endfor; ?>
        </div>

        <div class="actions">
          <button class="seir-btn primary" type="submit">Guardar</button>
          <a class="seir-btn light" href="/SEIR/public/preguntas">Cancelar</a>
        </div>
      </form>
    </div>

  </div>
</div>
