<div class="preguntas-page">
  <div class="page-head">
    <div>
      <h1 class="page-title">Preguntas del curso</h1>
      <p class="page-subtitle">Crea y administra preguntas de este curso (con imagen incluida).</p>
    </div>

    <div class="page-actions">
      <a class="btn-soft primary" href="/SEIR/public/preguntas/crear?curso=<?= (int)$idCurso ?>">
        <i class="bi bi-plus-circle"></i> Nueva pregunta
      </a>
      <a class="btn-soft" href="/SEIR/public/cursos/entrar?id=<?= (int)$idCurso ?>">
        <i class="bi bi-arrow-left"></i> Volver
      </a>
    </div>
  </div>

  <?php if (empty($preguntas)): ?>
    <div class="empty-card">Aún no hay preguntas en este curso.</div>
  <?php else: ?>
    <div class="seir-card">
      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>Enunciado</th>
              <th>Grado</th>
              <th>Dificultad</th>
              <th>Imagen</th>
              <th>Estado</th>
              <th class="text-end">Acciones</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($preguntas as $p): ?>
              <tr>
                <td><?= htmlspecialchars($p['enunciado']) ?></td>
                <td><?= htmlspecialchars($p['grado'] ?? 'TODOS') ?></td>
                <td><?= htmlspecialchars($p['dificultad']) ?></td>
                <td>
                  <?php if (!empty($p['imagen'])): ?>
                    <span class="badge bg-success">Sí</span>
                  <?php else: ?>
                    <span class="badge bg-secondary">No</span>
                  <?php endif; ?>
                </td>
                <td>
                  <?php if ((int)$p['activo'] === 1): ?>
                    <span class="badge bg-success">ACTIVO</span>
                  <?php else: ?>
                    <span class="badge bg-danger">INACTIVO</span>
                  <?php endif; ?>
                </td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary"
                     href="/SEIR/public/preguntas/editar?id=<?= (int)$p['id_pregunta'] ?>&curso=<?= (int)$idCurso ?>">
                    Editar
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  <?php endif; ?>
</div>
