<div class="seir-page partidas-page">

  <div class="seir-head">
    <div>
      <h2 class="seir-h2">Partida: <?= htmlspecialchars($partida['titulo']) ?></h2>
      <p class="seir-muted">
        Código: <strong><?= htmlspecialchars($partida['codigo']) ?></strong>
        <span class="seir-dot">•</span>
        Duración: <?= (int)$partida['duracion_total_min'] ?> min
      </p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-outline-light" href="/SEIR/public/partidas">← Volver</a>
    </div>
  </div>

  <?php if (!empty($ok)): ?>
    <div class="seir-alert seir-alert-success">
      ✅ <?= htmlspecialchars($ok) ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger">
      ⚠️ <?= htmlspecialchars($error) ?>
    </div>
  <?php endif; ?>

  <div class="seir-card seir-card-soft seir-animate-in">
    <div class="seir-card-body">

      <?php
        // ✅ Grado por defecto: si no viene GET grado, usa grado_objetivo de la partida
        $gradoObj = (string)($partida['grado_objetivo'] ?? 'TODOS');
        if ($gradoObj === '' || $gradoObj === '0') $gradoObj = 'TODOS';

        $gSel = (string)($grado ?? '');
        if ($gSel === '') $gSel = $gradoObj;

        // curso seleccionado (ya te lo manda controller como int)
        $cursoSel = (int)($cursoSel ?? 0);
      ?>

      <!-- ✅ FILTROS (GET) — OJO: YA NO VA DENTRO DEL FORM POST -->
      <form method="GET" action="/SEIR/public/partidas/preguntas" class="seir-form mb-3">
        <input type="hidden" name="id" value="<?= (int)$partida['id_partida'] ?>">
        <input type="hidden" name="grado" value="<?= htmlspecialchars($gSel) ?>">

        <div class="seir-grid-2">
          <div class="seir-field">
            <label class="seir-label">Filtrar por curso</label>
            <select class="seir-input"
                    name="curso"
                    onchange="this.form.submit()">
              <option value="0" <?= ($cursoSel===0?'selected':'') ?>>Todos los cursos</option>
              <?php foreach (($cursos ?? []) as $c): ?>
                <?php $idc = (int)$c['id_curso']; ?>
                <option value="<?= $idc ?>" <?= ($idc===$cursoSel?'selected':'') ?>>
                  <?= htmlspecialchars($c['nombre']) ?>
                </option>
              <?php endforeach; ?>
            </select>
            <div class="seir-help">
              Si la partida tiene curso asignado, este filtro arranca en ese curso automáticamente.
            </div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Tip</label>
            <div class="seir-help">
              Si eliges 1..5, verás preguntas de ese grado + las de “Todos”.
            </div>
          </div>
        </div>
      </form>

      <!-- ✅ FORM POST REAL (GUARDAR) -->
      <form method="POST" action="/SEIR/public/partidas/preguntas" class="seir-form">
        <input type="hidden" name="id_partida" value="<?= (int)$partida['id_partida'] ?>">

        <div class="seir-section">
          <div class="seir-section-title">Selecciona preguntas y asigna un orden</div>
          <div class="seir-help">Usa orden 1, 2, 3… sin repetir. (Si marcas, pon orden).</div>
        </div>

        <div class="seir-tabs">
          <div class="seir-tabs-left">
            <span class="seir-tabs-label">Carpetas por grado</span>

            <?php foreach (['TODOS'=>'Todos','1'=>'1°','2'=>'2°','3'=>'3°','4'=>'4°','5'=>'5°'] as $gVal=>$gTxt): ?>
              <?php
                $qs = http_build_query([
                  'id'    => (int)$partida['id_partida'],
                  'grado' => $gVal,
                  'curso' => $cursoSel,
                ]);
                $href = "/SEIR/public/partidas/preguntas?{$qs}";
              ?>
              <a class="seir-tab <?= ($gSel===$gVal?'is-active':'') ?>" href="<?= htmlspecialchars($href) ?>">
                <?= htmlspecialchars($gTxt) ?>
              </a>
            <?php endforeach; ?>
          </div>

          <div class="seir-tabs-hint">
            Si eliges 1..5, verás preguntas de ese grado + las de “Todos”.
          </div>
        </div>

        <div class="seir-table-wrap">
          <table class="seir-table">
            <thead>
              <tr>
                <th class="col-center">Sel</th>
                <th class="col-center">Orden</th>
                <th class="col-center">Puntos</th>
                <th>ID</th>
                <th>Enunciado</th>
                <th>Dificultad</th>
                <th>Grado</th>
              </tr>
            </thead>

            <tbody>
            <?php foreach (($banco ?? []) as $q):
              $idq = (int)$q['id_pregunta'];
              $checked = array_key_exists($idq, $mapOrden);
              $orden = $checked ? (int)$mapOrden[$idq] : '';
              $puntos = $checked ? (int)($mapPuntos[$idq] ?? 1) : 1;
            ?>
              <tr>
                <td class="col-center">
                  <input class="seir-check" type="checkbox" name="sel[<?= $idq ?>]" <?= $checked ? 'checked' : '' ?>>
                </td>

                <td class="col-center">
                  <input class="seir-input seir-input-sm seir-order"
                         type="number"
                         name="orden[<?= $idq ?>]"
                         value="<?= htmlspecialchars((string)$orden) ?>"
                         min="1">
                </td>

                <td class="col-center">
                  <input class="seir-input seir-input-sm"
                         type="number"
                         name="puntos[<?= $idq ?>]"
                         value="<?= (int)$puntos ?>"
                         min="1"
                         max="100"
                         title="Puntos si es correcta">
                </td>

                <td><span class="seir-code">#<?= $idq ?></span></td>
                <td class="seir-ellipsis"><?= htmlspecialchars(mb_strimwidth((string)$q['enunciado'], 0, 95, '...')) ?></td>

                <td>
                  <?php
                    $dif = strtoupper((string)$q['dificultad']);
                    $class = 'tag tag-soft';
                    if ($dif === 'FACIL') $class .= ' tag-ok';
                    if ($dif === 'MEDIA') $class .= ' tag-mid';
                    if ($dif === 'DIFICIL') $class .= ' tag-bad';
                  ?>
                  <span class="<?= $class ?>"><?= htmlspecialchars((string)$q['dificultad']) ?></span>
                </td>

                <td>
                  <span class="tag tag-soft"><?= htmlspecialchars((string)($q['grado'] ?? 'TODOS')) ?></span>
                </td>
              </tr>
            <?php endforeach; ?>

            <?php if (empty($banco)): ?>
              <tr>
                <td colspan="7" class="text-center text-muted py-4">
                  No hay preguntas para esos filtros.
                </td>
              </tr>
            <?php endif; ?>
            </tbody>
          </table>
        </div>

        <div class="seir-form-actions">
          <button class="btn btn-seir" type="submit">Guardar preguntas</button>
          <a class="btn btn-outline-light" href="/SEIR/public/partidas">Volver</a>
        </div>

      </form>

    </div>
  </div>
</div>
