<div class="seir-card partidas-index">

  <div class="seir-card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <h4 class="seir-title mb-0">
        <i class="bi bi-collection-play me-2"></i>Partidas
      </h4>
      <div class="seir-sub">Crea, inicia y revisa ranking de cada evaluación.</div>
    </div>

    <div class="d-flex flex-wrap gap-2">
      <a class="btn btn-seir" href="/SEIR/public/partidas/crear">
        <i class="bi bi-plus-circle me-1"></i>Nueva partida
      </a>
      <a class="btn btn-outline-dark" href="/SEIR/public/dashboard">
        <i class="bi bi-arrow-left me-1"></i>Volver
      </a>
    </div>
  </div>

  <div class="seir-card-body">

    <?php if (!empty($ok)): ?>
      <div class="alert alert-success d-flex align-items-center" role="alert">
        <i class="bi bi-check-circle-fill me-2"></i>
        <div><?= htmlspecialchars($ok) ?></div>
      </div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger d-flex align-items-center" role="alert">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        <div><?= htmlspecialchars($error) ?></div>
      </div>
    <?php endif; ?>

    <!-- ✅ FILTROS -->
    <form class="row g-2 mb-3" method="GET" action="/SEIR/public/partidas">
      <?php
        $qCurso  = (int)($_GET['curso'] ?? 0);
        $qEstado = (string)($_GET['estado'] ?? 'TODOS');
        $qGrado  = (string)($_GET['grado'] ?? '');
        $qDesde  = (string)($_GET['desde'] ?? '');
        $qHasta  = (string)($_GET['hasta'] ?? '');
      ?>

      <div class="col-12 col-md-3">
        <select name="curso" class="form-select">
          <option value="0">Todos los cursos</option>
          <?php foreach (($cursos ?? []) as $c): ?>
            <option value="<?= (int)$c['id_curso'] ?>" <?= ((int)$c['id_curso'] === $qCurso ? 'selected' : '') ?>>
              <?= htmlspecialchars($c['nombre']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-6 col-md-2">
        <select name="estado" class="form-select">
          <?php
            $estados = ['TODOS','CREADA','EN_CURSO','FINALIZADA'];
            foreach ($estados as $e):
          ?>
            <option value="<?= $e ?>" <?= ($qEstado === $e ? 'selected' : '') ?>><?= $e ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-6 col-md-2">
        <select name="grado" class="form-select">
          <option value="">Todos los grados</option>
          <option value="0" <?= ($qGrado==='0' ? 'selected' : '') ?>>TODOS</option>
          <option value="1" <?= ($qGrado==='1' ? 'selected' : '') ?>>1°</option>
          <option value="2" <?= ($qGrado==='2' ? 'selected' : '') ?>>2°</option>
          <option value="3" <?= ($qGrado==='3' ? 'selected' : '') ?>>3°</option>
          <option value="4" <?= ($qGrado==='4' ? 'selected' : '') ?>>4°</option>
          <option value="5" <?= ($qGrado==='5' ? 'selected' : '') ?>>5°</option>
        </select>
      </div>

      <div class="col-6 col-md-2">
        <input type="date" name="desde" class="form-control" value="<?= htmlspecialchars($qDesde) ?>">
      </div>

      <div class="col-6 col-md-2">
        <input type="date" name="hasta" class="form-control" value="<?= htmlspecialchars($qHasta) ?>">
      </div>

      <div class="col-12 col-md-1 d-grid">
        <button class="btn btn-outline-primary" type="submit">
          <i class="bi bi-funnel"></i>
        </button>
      </div>

      <div class="col-12 d-flex justify-content-end">
        <a class="btn btn-sm btn-outline-secondary" href="/SEIR/public/partidas">
          Limpiar filtros
        </a>
      </div>
    </form>

    <div class="table-responsive">
      <table class="table table-hover align-middle">
        <thead>
          <tr>
            <th>Código</th>
            <th>Título</th>
            <th>Grado</th>
            <th>Estado</th>
            <th>Duración</th>
            <th class="text-end">Acciones</th>
          </tr>
        </thead>

        <tbody>
        <?php foreach (($partidas ?? []) as $p): ?>

          <?php
            $g = (int)($p['grado_objetivo'] ?? 0);
            $gradoNombre = [0=>'TODOS',1=>'PRIMERO',2=>'SEGUNDO',3=>'TERCERO',4=>'CUARTO',5=>'QUINTO'];
            $gTxt = $gradoNombre[$g] ?? 'TODOS';

            $estado = (string)($p['estado'] ?? '');
            $badge = 'secondary';
            if ($estado === 'CREADA')     $badge = 'primary';
            if ($estado === 'EN_CURSO')   $badge = 'warning';
            if ($estado === 'FINALIZADA') $badge = 'success';
          ?>

          <tr>
            <td>
              <span class="badge-soft"><strong><?= htmlspecialchars((string)$p['codigo']) ?></strong></span>
            </td>

            <td class="partidas-title"><?= htmlspecialchars((string)$p['titulo']) ?></td>

            <td>
              <span class="seir-grade-pill <?= ($g===0 ? 'is-all' : 'is-grade') ?>">
                <?= htmlspecialchars($gTxt) ?>
              </span>
            </td>

            <td>
              <span class="badge text-bg-<?= $badge ?>"><?= htmlspecialchars($estado) ?></span>
            </td>

            <td><?= (int)($p['duracion_total_min'] ?? 0) ?> min</td>

            <td class="text-end">
              <div class="d-inline-flex flex-wrap gap-2 justify-content-end">

                <a class="btn btn-sm btn-outline-dark"
                   href="/SEIR/public/partidas/preguntas?id=<?= (int)$p['id_partida'] ?>">
                  <i class="bi bi-list-check me-1"></i>Preguntas
                </a>

                <a class="btn btn-sm btn-outline-primary"
                   href="/SEIR/public/partidas/ranking?id=<?= (int)$p['id_partida'] ?>">
                  <i class="bi bi-bar-chart-line me-1"></i>Ranking
                </a>

                <?php if ($estado === 'CREADA'): ?>
                  <a class="btn btn-sm btn-outline-secondary"
                     href="/SEIR/public/partidas/editar?id=<?= (int)$p['id_partida'] ?>">
                    <i class="bi bi-pencil-square me-1"></i>Editar
                  </a>

                  <form method="POST" action="/SEIR/public/partidas/eliminar" class="d-inline"
                        onsubmit="return confirm('¿Eliminar partida? Solo se elimina si está CREADA.');">
                    <input type="hidden" name="id_partida" value="<?= (int)$p['id_partida'] ?>">
                    <button class="btn btn-sm btn-outline-danger" type="submit">
                      <i class="bi bi-trash me-1"></i>Eliminar
                    </button>
                  </form>

                  <form method="POST" action="/SEIR/public/partidas/iniciar" class="d-inline"
                        onsubmit="return confirm('¿Iniciar partida?');">
                    <input type="hidden" name="id_partida" value="<?= (int)$p['id_partida'] ?>">
                    <button class="btn btn-sm btn-success" type="submit">
                      <i class="bi bi-play-fill me-1"></i>Iniciar
                    </button>
                  </form>
                <?php endif; ?>

                <?php if ($estado === 'EN_CURSO'): ?>
                  <!-- ✅ FASE 5: BOTÓN CONTROL -->
                  <a class="btn btn-sm btn-warning"
                     href="/SEIR/public/partidas/control?id=<?= (int)$p['id_partida'] ?>">
                    <i class="bi bi-broadcast-pin me-1"></i>Control
                  </a>

                  <form method="POST" action="/SEIR/public/partidas/finalizar" class="d-inline"
                        onsubmit="return confirm('¿Finalizar partida?');">
                    <input type="hidden" name="id_partida" value="<?= (int)$p['id_partida'] ?>">
                    <button class="btn btn-sm btn-danger" type="submit">
                      <i class="bi bi-stop-fill me-1"></i>Finalizar
                    </button>
                  </form>
                <?php endif; ?>

              </div>
            </td>
          </tr>

        <?php endforeach; ?>

        <?php if (empty($partidas)): ?>
          <tr>
            <td colspan="6" class="text-center text-muted py-4">
              No hay partidas con esos filtros.
            </td>
          </tr>
        <?php endif; ?>
        </tbody>

      </table>
    </div>

  </div>
</div>
