<div class="seir-page partidas-page">

  <div class="seir-head">
    <div>
      <h2 class="seir-h2">Editar partida</h2>
      <p class="seir-muted">Solo se puede editar si la partida está en estado <strong>CREADA</strong>.</p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-outline-light" href="/SEIR/public/partidas">← Volver</a>
    </div>
  </div>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger">
      <strong>Ups:</strong> <?= htmlspecialchars($error) ?>
    </div>
  <?php endif; ?>

  <div class="seir-card seir-card-soft seir-animate-in">
    <div class="seir-card-body">

      <form method="POST" action="/SEIR/public/partidas/editar" class="seir-form">
        <input type="hidden" name="id_partida" value="<?= (int)($p['id_partida'] ?? 0) ?>">

        <div class="seir-grid-2">

          <div class="seir-field">
            <label class="seir-label">Título</label>
            <input class="seir-input" name="titulo" required
              value="<?= htmlspecialchars((string)($p['titulo'] ?? '')) ?>">
          </div>

          <div class="seir-field">
            <label class="seir-label">Duración total (minutos)</label>
            <input class="seir-input" type="number" name="duracion_total_min" min="1" max="300" required
              value="<?= (int)($p['duracion_total_min'] ?? 30) ?>">
          </div>

          <div class="seir-field">
            <label class="seir-label">Grado objetivo</label>
            <?php $g = (int)($p['grado_objetivo'] ?? 0); ?>
            <select class="seir-input" name="grado_objetivo" required>
              <option value="0" <?= $g===0?'selected':'' ?>>TODOS</option>
              <option value="1" <?= $g===1?'selected':'' ?>>1°</option>
              <option value="2" <?= $g===2?'selected':'' ?>>2°</option>
              <option value="3" <?= $g===3?'selected':'' ?>>3°</option>
              <option value="4" <?= $g===4?'selected':'' ?>>4°</option>
              <option value="5" <?= $g===5?'selected':'' ?>>5°</option>
            </select>
          </div>

          <div class="seir-field">
            <label class="seir-label">Curso (opcional)</label>
            <?php $idCurso = (int)($p['id_curso'] ?? 0); ?>
            <select class="seir-input" name="id_curso">
              <option value="0">— Sin curso (Especial / General) —</option>
              <?php foreach (($cursos ?? []) as $c): ?>
                <option value="<?= (int)$c['id_curso'] ?>" <?= ((int)$c['id_curso'] === $idCurso ? 'selected' : '') ?>>
                  <?= htmlspecialchars($c['nombre']) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="seir-field">
            <label class="seir-label">Modo de preguntas</label>
            <?php $mp = (string)($p['modo_preguntas'] ?? 'ORDEN'); ?>
            <select class="seir-input" name="modo_preguntas">
              <option value="ORDEN" <?= $mp==='ORDEN'?'selected':'' ?>>En orden</option>
              <option value="ALEATORIO" <?= $mp==='ALEATORIO'?'selected':'' ?>>Aleatorio</option>
            </select>
          </div>

          <div class="seir-field">
            <label class="seir-label">Modo de alternativas</label>
            <?php $ma = (string)($p['modo_alternativas'] ?? 'FIJO'); ?>
            <select class="seir-input" name="modo_alternativas">
              <option value="FIJO" <?= $ma==='FIJO'?'selected':'' ?>>Fijas</option>
              <option value="ALEATORIO" <?= $ma==='ALEATORIO'?'selected':'' ?>>Aleatorias</option>
            </select>
          </div>

        </div>

        <div class="seir-form-actions">
          <button class="btn btn-seir" type="submit">Guardar cambios</button>
          <a class="btn btn-outline-light" href="/SEIR/public/partidas">Cancelar</a>
        </div>
      </form>

    </div>
  </div>
</div>
