<div class="seir-page partidas-page">

  <div class="seir-head">
    <div>
      <h2 class="seir-h2">Nueva partida</h2>
      <p class="seir-muted">Crea una evaluación y genera un código de acceso para tus estudiantes.</p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-outline-light" href="/SEIR/public/partidas">← Volver</a>
    </div>
  </div>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger">
      <strong>Ups:</strong> <?= htmlspecialchars($error) ?>
    </div>
  <?php endif; ?>

  <div class="seir-card seir-card-soft seir-animate-in">
    <div class="seir-card-body">

      <form method="POST" action="/SEIR/public/partidas/crear" class="seir-form">

        <div class="seir-grid-2">

          <div class="seir-field">
            <label class="seir-label">Título</label>
            <input class="seir-input" name="titulo" placeholder="Ej: Evaluación rápida" required>
            <div class="seir-help">Ponle un nombre corto para reconocer la partida.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Duración total (minutos)</label>
            <input class="seir-input" type="number" name="duracion_total_min" value="30" min="1" max="300" required>
            <div class="seir-help">Recomendado: 5 a 30 min para evaluaciones rápidas.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Grado objetivo</label>
            <select class="seir-input" name="grado_objetivo" required>
              <option value="0">TODOS</option>
              <option value="1">1°</option>
              <option value="2">2°</option>
              <option value="3">3°</option>
              <option value="4">4°</option>
              <option value="5">5°</option>
            </select>
            <div class="seir-help">Si eliges “TODOS”, cualquiera puede unirse.</div>
          </div>

          <!-- ✅ FASE 3: CURSO -->
          <div class="seir-field">
            <label class="seir-label">Curso (opcional)</label>
            <select class="seir-input" name="id_curso">
              <option value="0">— Sin curso (Especial / General) —</option>
              <?php foreach (($cursos ?? []) as $c): ?>
                <option value="<?= (int)$c['id_curso'] ?>">
                  <?= htmlspecialchars($c['nombre']) ?>
                </option>
              <?php endforeach; ?>
            </select>
            <div class="seir-help">Si eliges un curso, luego filtras preguntas más fácil.</div>
          </div>

          <!-- ✅ FASE 3: MODOS -->
          <div class="seir-field">
            <label class="seir-label">Modo de preguntas</label>
            <select class="seir-input" name="modo_preguntas">
              <option value="ORDEN" selected>En orden</option>
              <option value="ALEATORIO">Aleatorio</option>
            </select>
            <div class="seir-help">“Aleatorio” sirve para que no copien.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Modo de alternativas</label>
            <select class="seir-input" name="modo_alternativas">
              <option value="FIJO" selected>Fijas</option>
              <option value="ALEATORIO">Aleatorias</option>
            </select>
            <div class="seir-help">Aleatorio cambia A/B/C/D en cada estudiante.</div>
          </div>

        </div>

        <div class="seir-note">
          <span class="seir-note-icon">✅</span>
          El sistema generará automáticamente un <strong>código</strong> para que los estudiantes se unan.
        </div>

        <div class="seir-form-actions">
          <button class="btn btn-seir" type="submit">Crear partida</button>
          <a class="btn btn-outline-light" href="/SEIR/public/partidas">Cancelar</a>
        </div>

      </form>

    </div>
  </div>
</div>
