<div class="control-page">
  <div class="control-head">
    <div>
      <h2 class="control-title">Control de partida</h2>
      <div class="control-sub">
        <strong><?= htmlspecialchars($partida["titulo"] ?? "") ?></strong>
        <span class="chip">Código: <?= htmlspecialchars($partida["codigo"] ?? "") ?></span>
        <span class="chip" id="estadoChip"><?= htmlspecialchars($partida["estado"] ?? "") ?></span>
      </div>
    </div>

    <div class="control-actions">
      <a class="btn-soft" href="/SEIR/public/partidas">
        <i class="bi bi-arrow-left"></i> Volver
      </a>

      <!-- si quieres: botón finalizar acá también -->
      <form method="POST" action="/SEIR/public/partidas/finalizar" class="d-inline"
            onsubmit="return confirm('¿Finalizar partida?');">
        <input type="hidden" name="id_partida" value="<?= (int)$id_partida ?>">
        <button class="btn-soft danger" type="submit">
          <i class="bi bi-stop-fill"></i> Finalizar
        </button>
      </form>
    </div>
  </div>

  <div class="control-cards">
    <div class="kpi">
      <div class="kpi-label">Tiempo restante</div>
      <div class="kpi-value" id="kpiTiempo">--:--</div>
    </div>

    <div class="kpi">
      <div class="kpi-label">Preguntas</div>
      <div class="kpi-value" id="kpiPreg">0</div>
    </div>

    <div class="kpi">
      <div class="kpi-label">Conectados</div>
      <div class="kpi-value" id="kpiConn">0</div>
    </div>

    <div class="kpi">
      <div class="kpi-label">Finalizados</div>
      <div class="kpi-value" id="kpiFin">0</div>
    </div>
  </div>

  <div class="control-grid">
    <div class="panel">
      <div class="panel-head">
        <h3>Progreso por estudiante</h3>
        <span class="muted" id="lastUpdate">—</span>
      </div>

      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>Estudiante</th>
              <th>Progreso</th>
              <th class="text-center">Respondidas</th>
              <th class="text-end">Puntaje</th>
              <th class="text-center">Estado</th>
            </tr>
          </thead>
          <tbody id="tbodyParticipantes">
            <tr><td colspan="5" class="text-center text-muted py-4">Cargando…</td></tr>
          </tbody>
        </table>
      </div>
    </div>

    <div class="panel">
      <div class="panel-head">
        <h3>Top ranking</h3>
        <span class="muted">Actualiza solo</span>
      </div>

      <ol class="top-list" id="topList">
        <li class="muted">Cargando…</li>
      </ol>
    </div>
  </div>
</div>

<script>
(function(){
  const idPartida = <?= (int)$id_partida ?>;

  function fmtTime(sec){
    sec = Math.max(0, parseInt(sec||0,10));
    const m = Math.floor(sec/60);
    const s = sec % 60;
    return String(m).padStart(2,'0') + ":" + String(s).padStart(2,'0');
  }

  function escapeHtml(str){
    return String(str ?? '').replace(/[&<>"']/g, m => ({
      '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'
    }[m]));
  }

  async function tick(){
    try{
      const res = await fetch(`/SEIR/public/partidas/control/data?id=${idPartida}`, {cache:'no-store'});
      const data = await res.json();
      if(data.error){
        console.log(data.error);
        return;
      }

      // KPIs
      document.getElementById('estadoChip').textContent = data.partida.estado;
      document.getElementById('kpiTiempo').textContent = fmtTime(data.tiempo.segundos_restantes);
      document.getElementById('kpiPreg').textContent = data.tiempo.total_preguntas;
      document.getElementById('kpiConn').textContent = data.resumen.conectados;
      document.getElementById('kpiFin').textContent = data.resumen.finalizados;

      const now = new Date();
      document.getElementById('lastUpdate').textContent = "Actualizado: " + now.toLocaleTimeString();

      // tabla participantes
      const tbody = document.getElementById('tbodyParticipantes');
      const list = data.participantes || [];

      if(list.length === 0){
        tbody.innerHTML = `<tr><td colspan="5" class="text-center text-muted py-4">Aún no hay estudiantes conectados.</td></tr>`;
      } else {
        tbody.innerHTML = list.map(x => {
          const nombre = (x.nombres ? (x.nombres + " " + (x.apellidos||'')) : (x.alias||''));
          const resp = parseInt(x.respuestas_registradas||0,10);
          const total = parseInt(x.total_preguntas||0,10);
          const pct = parseInt(x.progreso_pct||0,10);
          const punt = parseFloat(x.puntaje_total||0);
          const fin = parseInt(x.finalizado||0,10) === 1;

          return `
          <tr>
            <td>
              <div class="who">
                <div class="who-name">${escapeHtml(nombre)}</div>
                <div class="who-sub">${escapeHtml(x.alias||'')}</div>
              </div>
            </td>
            <td style="min-width:220px">
              <div class="prog">
                <div class="prog-bar" style="width:${pct}%"></div>
              </div>
              <div class="muted small">${pct}%</div>
            </td>
            <td class="text-center"><strong>${resp}</strong> / ${total}</td>
            <td class="text-end"><strong>${punt.toFixed(2)}</strong></td>
            <td class="text-center">
              <span class="pill ${fin ? 'pill-ok':'pill-warn'}">${fin ? 'FINALIZADO':'EN PROCESO'}</span>
            </td>
          </tr>`;
        }).join('');
      }

      // top ranking
      const top = data.top || [];
      const topList = document.getElementById('topList');
      if(top.length === 0){
        topList.innerHTML = `<li class="muted">Aún no hay ranking.</li>`;
      } else {
        topList.innerHTML = top.map(r => {
          const nm = (r.nombres ? (r.nombres + " " + (r.apellidos||'')) : (r.alias||''));
          return `<li><span>${escapeHtml(nm)}</span><strong>${parseFloat(r.puntaje_total||0).toFixed(2)}</strong></li>`;
        }).join('');
      }

    }catch(err){
      console.log(err);
    }
  }

  tick();
  setInterval(tick, 2000);
})();
</script>
