<div class="seir-page">
  <div class="seir-hero d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <h3>Sala de espera</h3>
      <p>Cuando el docente inicie, entrarás al examen automáticamente.</p>
    </div>
    <span class="badge-soft"><i class="bi bi-hourglass-split"></i> En espera</span>
  </div>

  <div class="seir-body">
    <div class="seir-card p-4 form-card">
      <div class="row g-3">
        <div class="col-12 col-md-6">
          <div class="fw-semibold text-muted">Partida</div>
          <div class="fs-5 fw-bold"><?= htmlspecialchars($quiz['titulo']) ?></div>
        </div>
        <div class="col-6 col-md-3">
          <div class="fw-semibold text-muted">Código</div>
          <div class="kbd-pill d-inline-block mt-1"><?= htmlspecialchars($quiz['codigo']) ?></div>
        </div>
        <div class="col-6 col-md-3">
          <div class="fw-semibold text-muted">Alias</div>
          <div class="kbd-pill d-inline-block mt-1"><?= htmlspecialchars($quiz['alias']) ?></div>
        </div>
      </div>

      <hr>

      <div class="d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between gap-2">
        <div>
          <div class="fw-semibold text-muted">Estado</div>
          <div class="fs-6">
            <span class="badge bg-light text-dark border rounded-pill"><?= htmlspecialchars($quiz['estado']) ?></span>
          </div>

          <?php if ($quiz['estado'] === 'CREADA'): ?>
            <div class="mt-2 text-muted">
              <i class="bi bi-clock-history me-1"></i> Espera a que el docente inicie la partida.
            </div>
          <?php elseif ($quiz['estado'] === 'FINALIZADA'): ?>
            <div class="mt-2 text-success">
              <i class="bi bi-check-circle me-1"></i> La partida finalizó. Ya puedes ver resultados.
            </div>
          <?php endif; ?>
        </div>

        <div class="d-flex gap-2">
          <a class="btn btn-outline-secondary" href="/SEIR/public/sala">
            <i class="bi bi-arrow-repeat me-1"></i> Actualizar
          </a>
          <a class="btn btn-outline-dark" href="/SEIR/public/dashboard">
            <i class="bi bi-box-arrow-left me-1"></i> Salir
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  // Polling (sin websockets): cada 2s consultamos estado
  const estadoActual = <?= json_encode($quiz['estado'] ?? '') ?>;
  if (estadoActual === 'CREADA') {
    setInterval(async () => {
      try {
        const res = await fetch('/SEIR/public/sala/estado', { headers: { 'Accept': 'application/json' } });
        const data = await res.json();
        if (data && data.ok && data.estado === 'EN_CURSO') {
          window.location.href = '/SEIR/public/quiz';
        }
        if (data && data.ok && data.estado === 'FINALIZADA') {
          window.location.reload();
        }
      } catch (e) {}
    }, 2000);
  }
</script>
