<div class="seir-page">
  <div class="seir-hero d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <h3>Unirse a una partida</h3>
      <p>Ingresa el código y tu alias para pasar a la sala de espera.</p>
    </div>
    <span class="badge-soft"><i class="bi bi-key"></i> Estudiante</span>
  </div>

  <div class="seir-body">
    <div class="seir-card p-4 form-card">
      <?php if (!empty($error)): ?>
        <div class="alert alert-danger d-flex align-items-center" role="alert">
          <i class="bi bi-exclamation-triangle-fill me-2"></i>
          <div><?= htmlspecialchars($error) ?></div>
        </div>
      <?php endif; ?>

      <form method="POST" action="/SEIR/public/unirse">
        <div class="mb-3">
          <label class="form-label fw-semibold">Código de partida</label>
          <div class="input-group input-group-lg">
            <span class="input-group-text"><i class="bi bi-upc-scan"></i></span>
            <input type="text" name="codigo" class="form-control" placeholder="Ej: SEIR-12345" required>
          </div>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Tu alias</label>
          <div class="input-group input-group-lg">
            <span class="input-group-text"><i class="bi bi-person"></i></span>
            <input type="text" name="alias" class="form-control" placeholder="Ej: Juan01" required>
          </div>
          <div class="form-text">Se mostrará en el ranking.</div>
        </div>

        <div class="d-flex flex-column flex-sm-row gap-2">
          <button class="btn btn-seir btn-lg" type="submit">
            <i class="bi bi-box-arrow-in-right me-1"></i> Unirme
          </button>
          <a class="btn btn-outline-secondary btn-lg" href="/SEIR/public/dashboard">
            <i class="bi bi-arrow-left me-1"></i> Volver
          </a>
        </div>
      </form>

      <div class="mt-4 notice">
        <div class="d-flex align-items-center gap-2">
          <i class="bi bi-info-circle"></i>
          <div><strong>Tip:</strong> Cuando entres, espera a que el docente inicie la partida.</div>
        </div>
      </div>
    </div>
  </div>
</div>
