<?php
// ✅ Si algún controller no manda $user, lo sacamos de sesión
  if (!isset($user) && class_exists('Auth')) {
    $user = Auth::user();
  }
  $u = $user ?? null;

  $fullName = '';
  $rol = '';
  $initials = 'SE';

  if (is_array($u)) {
    $fullName = trim(($u['nombres'] ?? '') . ' ' . ($u['apellidos'] ?? ''));
    $rol = (string)($u['rol'] ?? '');

    if (!empty($u['nombres']) && !empty($u['apellidos'])) {
      $initials = mb_strtoupper(mb_substr($u['nombres'], 0, 1) . mb_substr($u['apellidos'], 0, 1));
    }
  }

  /* =========================================================
     A) Detectores de ruta (HOME / LOGIN)
     ========================================================= */
  $pageTitle = (string)($title ?? 'SEIR');

  $path = parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH) ?? '';
  $isHome  = ($path === '/SEIR/public/' || $path === '/SEIR/public');
  $isLogin = ($path === '/SEIR/public/login' || $path === '/SEIR/public/login/');

  /* =========================================================
     B) CSS por página
     ========================================================= */
  $pageCss = $pageCss ?? null;
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <!-- Libs -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

  <!-- CSS Global -->
  <link href="/SEIR/public/assets/css/app.css" rel="stylesheet">

  <!-- CSS por página -->
  <?php if (!empty($pageCss)): ?>
    <link href="<?= htmlspecialchars($pageCss) ?>" rel="stylesheet">
  <?php endif; ?>

  <!-- Favicon -->
  <link rel="icon" type="image/png" href="/SEIR/public/assets/img/seir-logo.png">
</head>

<body>
<div class="seir-shell">

  <?php if (!$isHome && !$isLogin): ?>
  <!-- TOPBAR (solo internas) -->
  <header class="topbar">
    <div class="inner">
      <a class="brand" href="/SEIR/public/dashboard">
        <span class="brand-badge"><i class="bi bi-mortarboard-fill"></i></span>
        <div>
          <div class="brand-title">SEIR</div>
          <div class="brand-sub">Sistema de Evaluación • Red Local</div>
        </div>
      </a>

      <?php if (!empty($u)): ?>
        <div class="userbox">
          <div class="userchip"><?= htmlspecialchars($initials) ?></div>
          <div class="user-meta d-none d-md-block">
            <div>Bienvenido(a): <strong><?= htmlspecialchars($fullName ?: 'Usuario') ?></strong></div>
            <div style="opacity:.85">Rol: <span class="kbd-pill"><?= htmlspecialchars($rol ?: '-') ?></span></div>
          </div>
          <div class="user-actions">
            <a href="/SEIR/public/logout" title="Cerrar sesión">
              <i class="bi bi-box-arrow-right"></i> <span class="d-none d-sm-inline">Salir</span>
            </a>
          </div>
        </div>
      <?php else: ?>
        <div class="user-actions">
          <a href="/SEIR/public/login">
            <i class="bi bi-box-arrow-in-right"></i> <span class="d-none d-sm-inline">Ingresar</span>
          </a>
        </div>
      <?php endif; ?>
    </div>
  </header>
  <?php endif; ?>

  <?php if (!$isHome && !$isLogin): ?>
    <!-- CONTENEDOR (solo internas) -->
    <main class="seir-container">
  <?php endif; ?>
