<?php
  // HOME público (sin sesión)
  $title   = "SEIR • Inicio";

  // CSS SOLO para el HOME
  $pageCss = "/SEIR/public/assets/css/pages/home.css";

  // Layout
  require __DIR__ . "/../layout/header.php";
?>

<!-- =========================
     HOME FULLSCREEN
     ========================= -->
<div class="seir-home-screen">

  <!-- Fondo (imagen completa) -->
  <div class="seir-home-bg"></div>

  <!-- Overlay suave (sin oscurecer) -->
  <div class="seir-home-vignette"></div>

  <!-- =========================
       ICONOS FLOTANTES
       ========================= -->
  <div class="seir-float seir-float-1">
    <i class="bi bi-laptop"></i>
  </div>

  <div class="seir-float seir-float-2">
    <i class="bi bi-journal-code"></i>
  </div>

  <div class="seir-float seir-float-3">
    <i class="bi bi-award"></i>
  </div>

  <div class="seir-float seir-float-4">
    <i class="bi bi-controller"></i>
  </div>

  <!-- =========================
       CONTENIDO CENTRAL
       ========================= -->
  <div class="seir-home-center">
    <div class="seir-home-card seir-anim">

      <!-- LOGO -->
      <div class="seir-home-logoWrap">
        <img
          class="seir-home-logo"
          src="/SEIR/public/assets/img/seir-logo.png"
          alt="SEIR Logo">
      </div>

      <!-- TITULO -->
      <h1 class="seir-home-title">SEIR</h1>

      <!-- SUBTITULO -->
      <div class="seir-home-subtitle">
        Sistema de Evaluación Interactiva en Red
      </div>

      <!-- TEXTO MINI -->
      <div class="seir-home-mini">
        Hecho para secundaria • Interactivo • Profesional • Sin internet (LAN)
      </div>

      <!-- BOTÓN -->
      <div class="seir-home-actions">
        <a class="btn seir-home-btn" href="/SEIR/public/login">
          ¡Comenzar! 🚀
        </a>
      </div>

      <!-- FOOTER MINI -->
      <div class="seir-home-foot">
        © 2026 SEIR • Funcionando en red local (sin internet).
      </div>

    </div>
  </div>

</div>

<?php
  require __DIR__ . "/../layout/footer.php";
?>
