<div class="seir-page estudiantes-page">

  <div class="seir-head">
    <div>
      <div class="seir-head-row">
        <h2 class="seir-h2">Estudiantes</h2>
        <span class="seir-chip">Gestión</span>
      </div>
      <p class="seir-muted">Listado y administración de estudiantes registrados.</p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-seir" href="/SEIR/public/estudiantes/crear">
        <i class="bi bi-person-plus-fill me-1"></i> Registrar estudiante
      </a>
      <a class="btn btn-outline-light" href="/SEIR/public/dashboard">
        <i class="bi bi-arrow-left me-1"></i> Volver
      </a>
    </div>
  </div>

  <?php if (!empty($ok)): ?>
    <div class="seir-alert seir-alert-success">
      ✅ <?= htmlspecialchars($ok) ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger">
      ⚠️ <?= htmlspecialchars($error) ?>
    </div>
  <?php endif; ?>

  <div class="seir-card seir-card-soft seir-animate-in">
    <div class="seir-card-body">

      <div class="seir-toolbar">
        <div class="seir-search">
          <i class="bi bi-search"></i>
          <input id="q" type="text" class="seir-search-input" placeholder="Buscar por DNI, nombres, apellidos, username...">
          <button id="clear" class="btn btn-sm btn-outline-dark" type="button">Limpiar</button>
        </div>

        <div class="seir-counter">
          Total: <span id="count"><?= count($estudiantes ?? []) ?></span>
        </div>
      </div>

      <div class="seir-table-wrap">
        <table id="tbl" class="seir-table">
          <thead>
            <tr>
              <th class="col-dni">DNI</th>
              <th>Nombres</th>
              <th>Apellidos</th>
              <th class="col-center col-grade">Grado</th>
              <th class="col-center col-sec">Sección</th>
              <th class="col-user">Username</th>
              <th class="col-center col-state">Estado</th>
              <th class="col-created">Creado</th>
              <th class="col-actions">Acciones</th>
            </tr>
          </thead>

          <tbody>
          <?php if (empty($estudiantes)): ?>
            <tr>
              <td colspan="9" class="seir-empty">
                No hay estudiantes registrados aún.
              </td>
            </tr>
          <?php else: ?>
            <?php foreach ($estudiantes as $e): ?>
              <?php
                $estado = strtoupper(trim((string)($e['estado'] ?? '')));
                $stClass = 'tag tag-soft';
                if ($estado === 'ACTIVO')   $stClass .= ' tag-ok';
                if ($estado === 'INACTIVO') $stClass .= ' tag-mid';
                if ($estado === 'BLOQUEADO')$stClass .= ' tag-bad';

                $created = (string)($e['created_at'] ?? '');
                $datePart = $created;
                $timePart = '';
                if (strpos($created, ' ') !== false) {
                  [$datePart, $timePart] = explode(' ', $created, 2);
                }
              ?>

              <tr>
                <td class="mono fw-900"><?= htmlspecialchars((string)$e['dni']) ?></td>

                <td class="fw-800"><?= htmlspecialchars((string)$e['nombres']) ?></td>
                <td><?= htmlspecialchars((string)$e['apellidos']) ?></td>

                <td class="col-center">
                  <span class="pill pill-grade"><?= htmlspecialchars((string)$e['grado']) ?></span>
                </td>

                <td class="col-center">
                  <span class="pill pill-sec"><?= htmlspecialchars((string)$e['seccion']) ?></span>
                </td>

                <td class="mono text-muted">
                  @<?= htmlspecialchars((string)$e['username']) ?>
                </td>

                <td class="col-center">
                  <span class="<?= $stClass ?>"><?= htmlspecialchars((string)$e['estado']) ?></span>
                </td>

                <td class="mono created-cell">
                  <div class="created-date"><?= htmlspecialchars($datePart) ?></div>
                  <?php if ($timePart !== ''): ?>
                    <div class="created-time"><?= htmlspecialchars($timePart) ?></div>
                  <?php endif; ?>
                </td>

                <td class="col-actions">
                  <div class="actions">
                    <a class="btn btn-sm btn-outline-primary"
                       href="/SEIR/public/estudiantes/editar?id=<?= (int)$e['id_usuario'] ?>">
                      <i class="bi bi-pencil-square me-1"></i>Editar
                    </a>

                    <form method="post"
                          action="/SEIR/public/estudiantes/eliminar"
                          class="m-0"
                          onsubmit="return confirm('¿Eliminar este estudiante?');">
                      <input type="hidden" name="id_usuario" value="<?= (int)$e['id_usuario'] ?>">
                      <button type="submit" class="btn btn-sm btn-outline-danger">
                        <i class="bi bi-trash3 me-1"></i>Eliminar
                      </button>
                    </form>
                  </div>
                </td>

              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>

        </table>
      </div>

      <div class="seir-footnote">SEIR • Módulo Estudiantes</div>
    </div>
  </div>
</div>

<script>
  // Buscador frontend
  const q = document.getElementById('q');
  const clear = document.getElementById('clear');
  const tbl = document.getElementById('tbl');
  const count = document.getElementById('count');

  function filter(){
    const term = (q.value || '').toLowerCase().trim();
    const rows = Array.from(tbl.querySelectorAll('tbody tr'));
    let visible = 0;

    rows.forEach(r => {
      // fila "no hay registros"
      if (r.children.length === 1) return;

      const text = r.innerText.toLowerCase();
      const show = text.includes(term);
      r.style.display = show ? '' : 'none';
      if (show) visible++;
    });

    if (count) count.textContent = String(visible);
  }

  q?.addEventListener('input', filter);
  clear?.addEventListener('click', () => { q.value=''; filter(); q.focus(); });
</script>
