<?php
  $dni       = htmlspecialchars($_POST['dni'] ?? '');
  $nombres   = htmlspecialchars($_POST['nombres'] ?? '');
  $apellidos = htmlspecialchars($_POST['apellidos'] ?? '');
  $grado     = htmlspecialchars($_POST['grado'] ?? '');
  $seccion   = htmlspecialchars($_POST['seccion'] ?? '');
?>

<div class="seir-page estudiantes-page">

  <div class="seir-head">
    <div>
      <h2 class="seir-h2">Registrar estudiante</h2>
      <p class="seir-muted">El DNI será el usuario y la clave inicial.</p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-outline-light" href="/SEIR/public/estudiantes">
        <i class="bi bi-arrow-left me-1"></i> Volver
      </a>
    </div>
  </div>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger">
      ⚠️ <?= htmlspecialchars($error) ?>
    </div>
  <?php endif; ?>

  <div class="seir-card seir-card-soft seir-animate-in" id="seir-student-form">
    <div class="seir-card-body">

      <div class="form-head">
        <div class="form-title">
          <div class="form-h">Registrar estudiante</div>
          <span class="form-badge is-new">Nuevo</span>
        </div>
        <div class="form-sub">El DNI será el usuario y la clave inicial.</div>
      </div>

      <form id="frm" method="POST" action="/SEIR/public/estudiantes/crear" class="seir-form" novalidate>

        <div class="seir-grid-2">
          <div class="seir-field seir-field-full">
            <label class="seir-label">DNI (será el username)</label>
            <input
              id="dni"
              class="seir-input"
              name="dni"
              placeholder="Ej: 70000001"
              required
              inputmode="numeric"
              maxlength="8"
              pattern="\d{8}"
              value="<?= $dni ?>"
            >
            <div class="seir-help">8 dígitos, solo números.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Nombres</label>
            <input class="seir-input" name="nombres" placeholder="Ej: Ana" required value="<?= $nombres ?>">
            <div class="seir-help">Ingresa los nombres del estudiante.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Apellidos</label>
            <input class="seir-input" name="apellidos" placeholder="Ej: Pérez" required value="<?= $apellidos ?>">
            <div class="seir-help">Ingresa los apellidos del estudiante.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Grado</label>
            <select class="seir-input" name="grado" required>
              <option value="" disabled <?= $grado===''?'selected':''; ?>>Seleccione...</option>
              <?php foreach (['1ro','2do','3ro','4to','5to'] as $g): ?>
                <option value="<?= htmlspecialchars($g) ?>" <?= ($grado === $g) ? 'selected' : '' ?>><?= htmlspecialchars($g) ?></option>
              <?php endforeach; ?>
            </select>
            <div class="seir-help">Selecciona el grado del estudiante.</div>
          </div>

          <div class="seir-field">
            <label class="seir-label">Sección</label>
            <select class="seir-input" name="seccion" required>
              <option value="" disabled <?= $seccion===''?'selected':''; ?>>Seleccione...</option>
              <?php foreach (['A','B','C','D'] as $s): ?>
                <option value="<?= htmlspecialchars($s) ?>" <?= ($seccion === $s) ? 'selected' : '' ?>><?= htmlspecialchars($s) ?></option>
              <?php endforeach; ?>
            </select>
            <div class="seir-help">Selecciona la sección.</div>
          </div>
        </div>

        <div class="seir-note">
          <span class="seir-note-icon"><i class="bi bi-check-circle-fill"></i></span>
          El sistema asignará: <strong>username = DNI</strong> y <strong>clave inicial = DNI</strong>.
        </div>

        <div class="seir-form-actions">
          <button class="btn btn-seir" type="submit">
            <i class="bi bi-save2 me-1"></i> Guardar
          </button>
          <a class="btn btn-outline-light" href="/SEIR/public/estudiantes">Cancelar</a>
        </div>

      </form>
    </div>
  </div>
</div>

<script>
  // DNI: solo números y 8 máximo
  const dni = document.getElementById('dni');
  dni?.addEventListener('input', () => {
    dni.value = dni.value.replace(/\D/g,'').slice(0,8);
  });

  // Validación rápida
  document.getElementById('frm')?.addEventListener('submit', (e) => {
    const form = e.target;
    if (!form.checkValidity()) {
      e.preventDefault();
      e.stopPropagation();
      form.classList.add('was-validated');
    }
  });
</script>
