<?php
  // Datos usuario
  $fullName = htmlspecialchars(($user['nombres'] ?? '') . " " . ($user['apellidos'] ?? ''));
  $rol      = htmlspecialchars($user['rol'] ?? '');
  $initials = 'SE';

  if (!empty($user['nombres']) && !empty($user['apellidos'])) {
    $initials = mb_strtoupper(
      mb_substr($user['nombres'],0,1) .
      mb_substr($user['apellidos'],0,1)
    );
  }

  $metrics = $metrics ?? [];
?>

<div class="seir-card admin-dashboard">
  <div class="seir-card-header d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
    <div>
      <div class="d-inline-flex align-items-center gap-2 mb-2">
        <span class="badge text-bg-success rounded-pill"><i class="bi bi-check2-circle me-1"></i>Sesión activa</span>
        <span class="badge text-bg-primary rounded-pill"><i class="bi bi-grid me-1"></i>Menú</span>
      </div>
      <h3 class="seir-title mb-1">Panel de control</h3>
      <div class="seir-sub">Gestiona SEIR desde un solo lugar.</div>
    </div>

  </div>

  <div class="seir-card-body">
    <div class="row g-3">

  <?php if (($user['rol'] ?? '') === 'ADMIN'): ?>

  <div class="col-12 col-md-6 col-lg-4">
    <a class="menu-link" href="/SEIR/public/admin/docentes">
      <div class="menu-card admin-card p-4 h-100">
        <div class="d-flex justify-content-between align-items-start gap-3">
          <div>
            <div class="icon-pill mb-3"><i class="bi bi-person-badge"></i></div>
            <h5 class="card-title mb-1">Docentes</h5>
            <p class="card-text mb-0">Crear, editar y activar/desactivar cuentas.</p>
          </div>
          <div class="arrow"><i class="bi bi-arrow-right"></i></div>
        </div>
      </div>
    </a>
  </div>

  <div class="col-12 col-md-6 col-lg-4">
    <a class="menu-link" href="/SEIR/public/admin/computadoras">
      <div class="menu-card admin-card p-4 h-100">
        <div class="d-flex justify-content-between align-items-start gap-3">
          <div>
            <div class="icon-pill mb-3"><i class="bi bi-pc-display"></i></div>
            <h5 class="card-title mb-1">Computadoras</h5>
            <p class="card-text mb-0">Ver estado LIBRE/OCUPADA por actividad.</p>
          </div>
          <div class="arrow"><i class="bi bi-arrow-right"></i></div>
        </div>
      </div>
    </a>
  </div>

  <div class="col-12 col-md-6 col-lg-4">
    <a class="menu-link" href="/SEIR/public/admin/config">
      <div class="menu-card admin-card p-4 h-100">
        <div class="d-flex justify-content-between align-items-start gap-3">
          <div>
            <div class="icon-pill mb-3"><i class="bi bi-gear"></i></div>
            <h5 class="card-title mb-1">Configuración</h5>
            <p class="card-text mb-0">Parámetros generales del sistema.</p>
          </div>
          <div class="arrow"><i class="bi bi-arrow-right"></i></div>
        </div>
      </div>
    </a>
  </div>

  <!-- ✅ KPIs debajo (reales desde BD) -->
  <div class="col-12">
    <div class="row g-3 mt-1 admin-kpis">
      <div class="col-12 col-md-4">
        <div class="admin-kpi">
          <div class="admin-kpi-value"><?= (int)($metrics['docentes_total'] ?? 0) ?></div>
          <div class="admin-kpi-label">DOCENTES REGISTRADOS</div>
        </div>
      </div>

      <div class="col-12 col-md-4">
        <div class="admin-kpi">
          <div class="admin-kpi-value"><?= (int)($metrics['estudiantes'] ?? 0) ?></div>
          <div class="admin-kpi-label">ESTUDIANTES</div>
        </div>
      </div>

      <div class="col-12 col-md-4">
        <div class="admin-kpi">
          <div class="admin-kpi-value admin-kpi-ok"><?= htmlspecialchars($metrics['sistema'] ?? 'Óptimo') ?></div>
          <div class="admin-kpi-label">SISTEMA</div>
        </div>
      </div>
    </div>
  </div>

<?php endif; ?>



    <?php if (($user['rol'] ?? '') === 'DOCENTE'): ?>

  <div class="col-12">
    <div class="teacher-dashboard">

      <div class="teacher-header mb-4">
        <h2 class="mb-1 text-white">¡Hola, Profe!</h2>
        <p class="mb-0 text-white-50">Gestiona tus evaluaciones y estudiantes desde un solo lugar.</p>
      </div>

      <div class="row g-3 mb-4">
        <div class="col-6 col-md-3">
          <div class="kpi-card">
            <div class="kpi-label">Evaluaciones</div>
            <div class="kpi-value"><?= (int)($metrics['evaluaciones'] ?? 0) ?></div>
          </div>
        </div>

        <div class="col-6 col-md-3">
          <div class="kpi-card">
            <div class="kpi-label">Preguntas</div>
            <div class="kpi-value"><?= (int)($metrics['preguntas'] ?? 0) ?></div>
          </div>
        </div>

        <div class="col-6 col-md-3">
          <div class="kpi-card">
            <div class="kpi-label">Estudiantes</div>
            <div class="kpi-value"><?= (int)($metrics['estudiantes'] ?? 0) ?></div>
          </div>
        </div>

        <div class="col-6 col-md-3">
          <div class="kpi-card">
            <div class="kpi-label">Promedio</div>
            <div class="kpi-value">
              <?php
                $p = $metrics['promedio'] ?? '—';
                echo ($p === '—') ? '—' : htmlspecialchars($p).'%';
              ?>
            </div>
          </div>
        </div>
      </div>

      <div class="row g-4">
        <div class="col-12 col-md-6 col-lg-4">
          <a href="/SEIR/public/cursos" class="teacher-card">
            <div class="icon bg-primary"><i class="bi bi-journal-bookmark"></i></div>
            <h5>Cursos</h5>
            <p>Organiza preguntas por curso.</p>
            <span class="btn btn-primary btn-sm">Acceder</span>
          </a>
        </div>

        <div class="col-12 col-md-6 col-lg-4">
          <a href="/SEIR/public/partidas" class="teacher-card">
            <div class="icon bg-success"><i class="bi bi-play-circle"></i></div>
            <h5>Crear partida</h5>
            <p>Inicia evaluaciones con código.</p>
            <span class="btn btn-primary btn-sm">Acceder</span>
          </a>
        </div>

        <div class="col-12 col-md-6 col-lg-4">
          <a href="/SEIR/public/estudiantes" class="teacher-card">
            <div class="icon bg-warning"><i class="bi bi-people"></i></div>
            <h5>Registrar estudiantes</h5>
            <p>Añade y gestiona alumnos.</p>
            <span class="btn btn-primary btn-sm">Acceder</span>
          </a>
        </div>

        <div class="col-12 col-md-6 col-lg-12">
          <a href="/SEIR/public/resultado" class="teacher-card">
            <div class="icon bg-info"><i class="bi bi-bar-chart"></i></div>
            <h5>Ver puntajes</h5>
            <p>Resumen de rendimiento por partida y acceso al ranking.</p>
            <span class="btn btn-primary btn-sm">Acceder</span>
          </a>
        </div>
      </div>

    </div>
  </div>

<?php endif; ?>
      
      


      <!-- ================= ESTUDIANTE (NO TOCAR) ================= -->
      <?php if (($user['rol'] ?? '') === 'ESTUDIANTE'): ?>
        <div class="col-12 col-md-6 col-lg-4">
          <a class="menu-link" href="/SEIR/public/unirse">
            <div class="menu-card p-4 h-100">
              <div class="d-flex justify-content-between align-items-start gap-3">
                <div>
                  <div class="icon-pill mb-3"><i class="bi bi-key"></i></div>
                  <h5 class="card-title mb-1">Unirse a partida</h5>
                  <p class="card-text mb-0">Ingresa el código y espera el inicio.</p>
                </div>
                <div class="arrow"><i class="bi bi-arrow-right"></i></div>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-md-6 col-lg-4">
          <a class="menu-link" href="/SEIR/public/mis-resultados">
            <div class="menu-card p-4 h-100">
              <div class="d-flex justify-content-between align-items-start gap-3">
                <div>
                  <div class="icon-pill mb-3"><i class="bi bi-bar-chart"></i></div>
                  <h5 class="card-title mb-1">Mis resultados</h5>
                  <p class="card-text mb-0">Historial de puntajes y ranking.</p>
                </div>
                <div class="arrow"><i class="bi bi-arrow-right"></i></div>
              </div>
            </div>
          </a>
        </div>
      <?php endif; ?>


      <!-- ================= SALIR ================= -->
      <div class="col-12">
        <a class="menu-link" href="/SEIR/public/logout">
          <div class="menu-card p-4">
            <div class="d-flex justify-content-between align-items-center gap-3">
              <div class="d-flex align-items-center gap-3">
                <div class="icon-pill icon-danger"><i class="bi bi-box-arrow-right"></i></div>
                <div>
                  <h5 class="card-title mb-1">Cerrar sesión</h5>
                  <p class="card-text mb-0">Salir de forma segura del sistema.</p>
                </div>
              </div>
              <div class="arrow"><i class="bi bi-arrow-right"></i></div>
            </div>
          </div>
        </a>
      </div>

    </div>
  </div>
</div>

<?php require __DIR__ . '/../layout/footer.php'; ?>
