<?php 
  // View::render() ya carga header y footer, aquí solo va contenido.
?>

<div class="cursos-page">
  <div class="page-shell">

    <div class="page-head">
      <div>
        <h1 class="page-title">Cursos</h1>
        <p class="page-subtitle">
          Organiza tus preguntas y evaluaciones por curso (tipo colegio real).
        </p>
      </div>

      <div class="page-actions">
        <a class="btn-soft primary" href="/SEIR/public/cursos/crear">
          <i class="bi bi-plus-circle"></i> Nuevo curso
        </a>
        <a class="btn-soft" href="/SEIR/public/dashboard">
          <i class="bi bi-arrow-left"></i> Volver
        </a>
      </div>
    </div>

    <?php if (!empty($ok)): ?>
      <div class="seir-alert success"><?= htmlspecialchars($ok) ?></div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
      <div class="seir-alert error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if (empty($cursos)): ?>
      <div class="empty-state">
        <div class="empty-card">
          <div class="empty-title">Aún no tienes cursos.</div>
          <div class="empty-sub">
            Crea tu primer curso para empezar a organizar preguntas y partidas.
          </div>
          <a class="btn-soft primary mt-2" href="/SEIR/public/cursos/crear">
            <i class="bi bi-plus-circle"></i> Crear curso
          </a>
        </div>
      </div>
    <?php else: ?>
      <div class="course-grid">
        <?php foreach ($cursos as $c): ?>
          <div class="course-card">

            <div class="course-name">
              <?= htmlspecialchars($c["nombre"]) ?>
            </div>

            <?php if (!empty($c["descripcion"])): ?>
              <div class="course-desc">
                <?= htmlspecialchars($c["descripcion"]) ?>
              </div>
            <?php endif; ?>

            <div class="course-meta">
              <span class="pill">
                <i class="bi bi-question-circle"></i>
                <?= (int)($c["total_preguntas"] ?? 0) ?> preguntas
              </span>

              <span class="pill <?= ((int)$c["activo"] === 1) ? "pill-ok" : "pill-off" ?>">
                <?= ((int)$c["activo"] === 1) ? "ACTIVO" : "INACTIVO" ?>
              </span>
            </div>

            <div class="course-actions">
              <a class="btn-soft success" href="/SEIR/public/cursos/entrar?id=<?= (int)$c["id_curso"] ?>">
                <i class="bi bi-door-open"></i> Entrar
              </a>
              <a class="btn-soft" href="/SEIR/public/cursos/editar?id=<?= (int)$c["id_curso"] ?>">
                <i class="bi bi-pencil-square"></i> Editar
              </a>
            </div>

          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

  </div>
</div>
