<?php $c = $curso ?? []; ?>

<div class="cursos-page">
  <div class="page-shell">

    <div class="page-head">
      <div>
        <h1 class="page-title">Editar curso</h1>
        <p class="page-subtitle">Actualiza el nombre o estado del curso.</p>
      </div>
      <div class="page-actions">
        <a class="btn-soft" href="/SEIR/public/cursos">
          <i class="bi bi-arrow-left"></i> Volver
        </a>
      </div>
    </div>

    <?php if (!empty($error)): ?>
      <div class="seir-alert error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="seir-card">
      <form method="post" action="/SEIR/public/cursos/editar" class="seir-form">
        <input type="hidden" name="id_curso" value="<?= (int)($c["id_curso"] ?? 0) ?>">

        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">Nombre del curso</label>
            <input class="form-control seir-input" name="nombre" required
              value="<?= htmlspecialchars($c["nombre"] ?? "") ?>">
          </div>

          <div class="form-group">
            <label class="form-label">Estado</label>
            <select class="form-control seir-input" name="estado">
              <option value="ACTIVO" <?= (($c["estado"] ?? "ACTIVO") === "ACTIVO") ? "selected" : "" ?>>ACTIVO</option>
              <option value="INACTIVO" <?= (($c["estado"] ?? "") === "INACTIVO") ? "selected" : "" ?>>INACTIVO</option>
            </select>
          </div>
        </div>

        <div class="form-actions">
          <button class="btn-soft primary" type="submit">
            <i class="bi bi-save2"></i> Guardar cambios
          </button>
          <a class="btn-soft" href="/SEIR/public/cursos">
            <i class="bi bi-x-circle"></i> Cancelar
          </a>
        </div>
      </form>
    </div>

  </div>
</div>
