<div class="cursos-page">
  <div class="page-shell">

    <div class="page-head">
      <div>
        <h1 class="page-title">Nuevo curso</h1>
        <p class="page-subtitle">Crea un curso para organizar preguntas y evaluaciones.</p>
      </div>
      <div class="page-actions">
        <a class="btn-soft" href="/SEIR/public/cursos">
          <i class="bi bi-arrow-left"></i> Volver
        </a>
      </div>
    </div>

    <?php if (!empty($error)): ?>
      <div class="seir-alert error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="seir-card">
      <form method="post" action="/SEIR/public/cursos/crear" class="seir-form">
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">Nombre del curso</label>
            <input class="form-control seir-input" name="nombre" required placeholder="Ej: Matemática, Comunicación...">
            <div class="form-hint">Este nombre aparecerá en tu lista de cursos.</div>
          </div>

          <div class="form-group">
            <label class="form-label">Estado</label>
            <select class="form-control seir-input" name="estado">
              <option value="ACTIVO" selected>ACTIVO</option>
              <option value="INACTIVO">INACTIVO</option>
            </select>
          </div>
        </div>

        <div class="form-actions">
          <button class="btn-soft primary" type="submit">
            <i class="bi bi-check2-circle"></i> Guardar curso
          </button>
          <a class="btn-soft" href="/SEIR/public/cursos">
            <i class="bi bi-x-circle"></i> Cancelar
          </a>
        </div>
      </form>
    </div>

  </div>
</div>
