<?php
  /* =========================================================
     SEIR • LOGIN VIEW
     Archivo: app/views/auth/login.php
     ========================================================= */

  $title   = "SEIR • Ingresar";
  $pageCss = "/SEIR/public/assets/css/pages/login.css";

  // Si estás usando variables de error:
  // $error = $error ?? null;

  require __DIR__ . '/../layout/header.php';
?>

<section class="seir-login-screen">
  <!-- ===== A) Fondo ===== -->
  <div class="seir-login-bg"></div>

  <!-- ===== B) Card ===== -->
  <div class="seir-login-card seir-anim">
    <div class="seir-login-grid">

      <!-- =========================================================
           C) IZQUIERDA: FORM
           ========================================================= -->
      <div class="seir-login-left">

        <!-- Brand mini (NO es topbar, es parte del login) -->
        <div class="seir-login-brandrow">
          <div class="seir-login-logoBox">
            <!-- ✅ Logo pequeño para login:
                 Si quieres otro, usa: /public/assets/img/login-logo.png
            -->
            <img src="/SEIR/public/assets/img/seir-logo.png" alt="SEIR">
          </div>

          <div class="seir-login-brandtxt">
            <div class="t">SEIR</div>
            <div class="s">Sistema de Evaluación • Red Local</div>
          </div>
        </div>

        <h1 class="seir-login-title">Bienvenido</h1>
        <p class="seir-login-desc">Ingresa con tu usuario para continuar. Funciona en red local (LAN).</p>

        <!-- (Opcional) Alert de error -->
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger" style="border-radius:16px;">
            <?= htmlspecialchars($error) ?>
          </div>
        <?php endif; ?>

        <!-- FORM -->
        <form method="POST" action="/SEIR/public/login">
          <div class="mb-3">
            <label class="form-label">Usuario</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-person"></i></span>
              <input name="username" class="form-control" placeholder="DNI o usuario" required>
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Contraseña</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-lock"></i></span>
              <input type="password" name="password" class="form-control" placeholder="Contraseña" required>
            </div>
          </div>

          <!-- ✅ Sin “Olvidaste tu contraseña” (tal como pediste) -->

          <button class="seir-login-btn" type="submit">
            <i class="bi bi-box-arrow-in-right"></i> Ingresar
          </button>

          <div class="seir-login-mini">
            © 2026 SEIR • Acceso seguro en red local.
          </div>
        </form>

      </div>

      <!-- =========================================================
           D) DERECHA: MENSAJES + DECOR
           ========================================================= -->
      <div class="seir-login-right" id="loginRight">
        <div class="seir-login-decor"></div>

        <h2>Evaluaciones sin internet</h2>
        <div class="k">Hecho para secundaria • rápido • profesional • LAN</div>

        <div class="login-messages" id="loginMsgs">
          <div class="msg active">
            <div class="q">“Aprender en equipo hace la clase más fuerte.”</div>
            <div class="a">— Aula</div>
          </div>
          <div class="msg">
            <div class="q">“Tu esfuerzo de hoy es tu resultado de mañana.”</div>
            <div class="a">— Motivación</div>
          </div>
          <div class="msg">
            <div class="q">“Disciplina > ganas. Siempre.”</div>
            <div class="a">— Enfoque</div>
          </div>
          <div class="msg">
            <div class="q">“No compitas con otros: mejora tu versión de ayer.”</div>
            <div class="a">— SEIR</div>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<!-- =========================================================
     E) JS: Rotación de frases + (opcional) imágenes
     Dónde va esto?
     ✅ Aquí mismo en login.php (solo afecta login)
     ========================================================= -->
<script>
  // ===== 1) Rotación de FRASES =====
  (function(){
    const msgs = document.querySelectorAll('#loginMsgs .msg');
    let i = 0;
    if (!msgs.length) return;

    setInterval(() => {
      msgs.forEach(m => m.classList.remove('active'));
      msgs[i].classList.add('active');
      i = (i + 1) % msgs.length;
    }, 3200);
  })();

  // ===== 2) (Opcional) Rotación de IMÁGENES de fondo a la derecha =====
  // 👉 Si quieres esto: crea imágenes en:
  // public/assets/img/login/
  //   - login-1.jpg
  //   - login-2.jpg
  //   - login-3.jpg
  //
  // y se rotan solas.
  (function(){
    const right = document.getElementById('loginRight');
    if (!right) return;

    const imgs = [
      '/SEIR/public/assets/img/login/login-1.jpg',
      '/SEIR/public/assets/img/login/login-2.jpg',
      '/SEIR/public/assets/img/login/login-3.jpg'
    ];

    let k = 0;

    function setBg(){
      // se pinta en ::before via variable css (más limpio)
      right.style.setProperty('--loginBg', `url("${imgs[k]}")`);
      k = (k + 1) % imgs.length;
    }

    // Si no existen tus imágenes aún, esto no rompe nada.
    setBg();
    setInterval(setBg, 5000);
  })();
</script>

<?php require __DIR__ . '/../layout/footer.php'; ?>

