<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<style>
  body{
    background: linear-gradient(135deg, #0b1220, #f8fafc);
    min-height: 100vh;
  }
  .page-wrap{ max-width: 1200px; margin: 0 auto; }
  .soft-card{
    border: 1px solid rgba(15,23,42,.08);
    border-radius: 18px;
    background: #ffffff;
    box-shadow: 0 18px 50px rgba(2,6,23,.08);
  }
  .header-chip{
    background: rgba(32,201,151,.10);
    border: 1px solid rgba(32,201,151,.18);
    color: #0f766e;
  }
  .table-wrapper {
    background: rgba(255,255,255,.80);
    border-radius: 18px;
    padding: 10px;
    box-shadow: 0 18px 50px rgba(0,0,0,.12);
  }
  .table thead th{
    position: sticky;
    top: 0;
    background: #f8fafc;
    z-index: 1;
  }
  .mono { font-variant-numeric: tabular-nums; font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; }
  .pill{
    background: rgba(13,110,253,.10);
    border: 1px solid rgba(13,110,253,.18);
    color: #0b5ed7;
  }
</style>

<div class="container py-4">
  <div class="page-wrap">

    <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center gap-3 mb-3">
      <div>
        <div class="d-flex align-items-center gap-2 mb-1">
          <h2 class="mb-0">Docentes</h2>
          <span class="badge rounded-pill header-chip">Admin • CU1</span>
        </div>
        <div class="text-secondary">Gestiona cuentas de docentes: crear, editar, activar/desactivar y resetear clave.</div>
      </div>

      <div class="d-flex gap-2">
        <a class="btn btn-success" href="/SEIR/public/admin/docentes/crear">
          <span class="me-1">+</span> Nuevo docente
        </a>
        <a class="btn btn-outline-light" href="/SEIR/public/dashboard">Volver</a>
      </div>
    </div>

    <?php if (!empty($ok)): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($ok) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($error) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <div class="card soft-card overflow-hidden">
      <div class="card-body p-4">

        <div class="row g-2 align-items-center mb-3">
          <div class="col-12 col-lg-6">
            <div class="input-group">
              <span class="input-group-text">🔎</span>
              <input id="q" type="text" class="form-control" placeholder="Buscar por nombres, apellidos, username, especialidad...">
              <button id="clear" class="btn btn-outline-secondary" type="button">Limpiar</button>
            </div>
          </div>
          <div class="col-12 col-lg-6 d-flex justify-content-lg-end">
            <span class="badge text-bg-light border">
              Total: <span id="count"><?= count($docentes ?? []) ?></span>
            </span>
          </div>
        </div>

        <div class="table-wrapper">
          <table id="tbl" class="table table-hover align-middle table-striped mb-0">
            <thead>
              <tr>
                <th>ID</th>
                <th>Nombres</th>
                <th>Apellidos</th>
                <th>Username</th>
                <th>Especialidad</th>
                <th>Estado</th>
                <th>Creado</th>
                <th style="width:260px">Acciones</th>
              </tr>
            </thead>
            <tbody>
            <?php if (empty($docentes)): ?>
              <tr>
                <td colspan="8" class="text-center text-secondary py-5">No hay docentes registrados aún.</td>
              </tr>
            <?php else: ?>
              <?php foreach ($docentes as $d): ?>
                <?php
                  $estado = strtoupper(trim($d['estado'] ?? ''));
                  $badge = match ($estado) {
                    'ACTIVO'    => 'text-bg-success',
                    'INACTIVO'  => 'text-bg-secondary',
                    'BLOQUEADO' => 'text-bg-danger',
                    default     => 'text-bg-primary'
                  };
                ?>
                <tr>
                  <td class="mono fw-semibold"><?= (int)$d['id_usuario'] ?></td>
                  <td><?= htmlspecialchars($d['nombres']) ?></td>
                  <td><?= htmlspecialchars($d['apellidos']) ?></td>
                  <td class="mono text-secondary">@<?= htmlspecialchars($d['username']) ?></td>
                  <td>
                    <?php if (!empty($d['especialidad'])): ?>
                      <span class="badge rounded-pill pill"><?= htmlspecialchars($d['especialidad']) ?></span>
                    <?php else: ?>
                      <span class="text-secondary">—</span>
                    <?php endif; ?>
                  </td>
                  <td><span class="badge rounded-pill <?= $badge ?>"><?= htmlspecialchars($d['estado']) ?></span></td>
                  <td class="mono text-secondary"><?= htmlspecialchars($d['created_at']) ?></td>

                  <td>
                    <div class="d-flex flex-wrap gap-2">
                      <a class="btn btn-sm btn-outline-primary" href="/SEIR/public/admin/docentes/editar?id=<?= (int)$d['id_usuario'] ?>">Editar</a>

                      <form method="post" action="/SEIR/public/admin/docentes/estado" class="m-0">
                        <input type="hidden" name="id_usuario" value="<?= (int)$d['id_usuario'] ?>">
                        <input type="hidden" name="estado" value="<?= htmlspecialchars($d['estado']) ?>">
                        <?php if ($estado === 'ACTIVO'): ?>
                          <button class="btn btn-sm btn-outline-secondary" type="submit">Desactivar</button>
                        <?php else: ?>
                          <button class="btn btn-sm btn-outline-success" type="submit">Activar</button>
                        <?php endif; ?>
                      </form>

                      <button
                        class="btn btn-sm btn-outline-dark"
                        type="button"
                        data-bs-toggle="modal"
                        data-bs-target="#resetModal"
                        data-id="<?= (int)$d['id_usuario'] ?>"
                        data-username="<?= htmlspecialchars($d['username']) ?>"
                        data-nombre="<?= htmlspecialchars($d['nombres'] . ' ' . $d['apellidos']) ?>">
                        Reset clave
                      </button>

                      <form method="post" action="/SEIR/public/admin/docentes/eliminar" class="m-0" onsubmit="return confirm('¿Eliminar este docente? Esta acción no se puede deshacer.');">
                        <input type="hidden" name="id_usuario" value="<?= (int)$d['id_usuario'] ?>">
                        <button class="btn btn-sm btn-outline-danger" type="submit">Eliminar</button>
                      </form>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
          </table>
        </div>

      </div>
    </div>

    <div class="text-center text-secondary mt-3 small">SEIR • Admin • Gestión de docentes</div>
  </div>
</div>

<!-- Modal Reset -->
<div class="modal fade" id="resetModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="/SEIR/public/admin/docentes/reset">
        <div class="modal-header">
          <h5 class="modal-title">Resetear contraseña</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id_usuario" id="reset_id">
          <div class="mb-2 text-secondary">
            Docente: <strong id="reset_nombre"></strong>
            <div class="small">Si dejas vacío, la clave se reseteará al <span class="mono" id="reset_user"></span>.</div>
          </div>
          <label class="form-label">Nueva clave (opcional)</label>
          <input class="form-control" type="text" name="nueva_clave" placeholder="Ej: 123456">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-dark">Resetear</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  const q = document.getElementById('q');
  const clear = document.getElementById('clear');
  const tbl = document.getElementById('tbl');
  const count = document.getElementById('count');

  function filter(){
    const term = (q.value || '').toLowerCase().trim();
    const rows = Array.from(tbl.querySelectorAll('tbody tr'));
    let visible = 0;
    rows.forEach(r => {
      if (r.children.length === 1) return;
      const text = r.innerText.toLowerCase();
      const show = text.includes(term);
      r.style.display = show ? '' : 'none';
      if (show) visible++;
    });
    if (count) count.textContent = visible || 0;
  }
  q?.addEventListener('input', filter);
  clear?.addEventListener('click', () => { q.value=''; filter(); q.focus(); });

  const resetModal = document.getElementById('resetModal');
  resetModal?.addEventListener('show.bs.modal', event => {
    const btn = event.relatedTarget;
    document.getElementById('reset_id').value = btn.getAttribute('data-id');
    document.getElementById('reset_user').textContent = '@' + btn.getAttribute('data-username');
    document.getElementById('reset_nombre').textContent = btn.getAttribute('data-nombre');
  });
</script>
