<?php
  $title   = 'SEIR • Editar docente';
  $pageCss = '/SEIR/public/assets/css/pages/admin-docentes.css';

  $d = $docente ?? [];
  $error = $error ?? '';
?>

<section class="admin-docentes">
  <div class="seir-head">
    <div>
      <h2 class="seir-h2">Editar docente</h2>
      <p class="seir-muted">
        ID: <span class="mono"><?= (int)($d['id_usuario'] ?? 0) ?></span>
        • Usuario: <span class="mono">@<?= htmlspecialchars($d['username'] ?? '') ?></span>
      </p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-outline-light" href="/SEIR/public/admin/docentes">
        <i class="bi bi-arrow-left me-1"></i> Volver
      </a>
    </div>
  </div>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <div class="seir-card-soft" style="max-width:780px">
    <div class="seir-card-body">
      <form method="post" action="/SEIR/public/admin/docentes/editar" class="row g-3">
        <input type="hidden" name="id_usuario" value="<?= (int)($d['id_usuario'] ?? 0) ?>">

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Nombres</label>
          <input class="form-control" name="nombres" required value="<?= htmlspecialchars($d['nombres'] ?? '') ?>">
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Apellidos</label>
          <input class="form-control" name="apellidos" required value="<?= htmlspecialchars($d['apellidos'] ?? '') ?>">
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Username</label>
          <input class="form-control" name="username" required value="<?= htmlspecialchars($d['username'] ?? '') ?>">
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Especialidad</label>
          <input class="form-control" name="especialidad" value="<?= htmlspecialchars($d['especialidad'] ?? '') ?>">
        </div>

        <div class="col-12 d-flex gap-2 mt-2">
          <button class="btn btn-primary" type="submit">
            <i class="bi bi-save2 me-1"></i> Guardar cambios
          </button>
          <a class="btn btn-outline-secondary" href="/SEIR/public/admin/docentes">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</section>
