<?php
  $title   = 'SEIR • Nuevo docente';
  $pageCss = '/SEIR/public/assets/css/pages/admin-docentes.css';
  $error = $error ?? '';
?>

<section class="admin-docentes">
  <div class="seir-head">
    <div>
      <h2 class="seir-h2">Nuevo docente</h2>
      <p class="seir-muted">Crea una cuenta de docente (usuario + rol docente).</p>
    </div>

    <div class="seir-actions">
      <a class="btn btn-outline-light" href="/SEIR/public/admin/docentes">
        <i class="bi bi-arrow-left me-1"></i> Volver
      </a>
    </div>
  </div>

  <?php if (!empty($error)): ?>
    <div class="seir-alert seir-alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <div class="seir-card-soft" style="max-width:780px">
    <div class="seir-card-body">
      <form method="post" action="/SEIR/public/admin/docentes/crear" class="row g-3">
        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Nombres</label>
          <input class="form-control" name="nombres" required placeholder="Ej: Carlos">
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Apellidos</label>
          <input class="form-control" name="apellidos" required placeholder="Ej: Pérez">
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Username</label>
          <input class="form-control" name="username" required placeholder="Ej: docente2 o DNI">
          <div class="form-text">Será el usuario con el que inicia sesión.</div>
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label fw-bold">Especialidad (opcional)</label>
          <input class="form-control" name="especialidad" placeholder="Ej: Matemática">
        </div>

        <div class="col-12">
          <label class="form-label fw-bold">Clave inicial (opcional)</label>
          <input class="form-control" name="clave_inicial" placeholder="Si lo dejas vacío, será igual al username">
          <div class="form-text">Recomendación: usar una clave temporal y luego resetear.</div>
        </div>

        <div class="col-12 d-flex gap-2 mt-2">
          <button class="btn btn-success" type="submit">
            <i class="bi bi-check2-circle me-1"></i> Guardar docente
          </button>
          <a class="btn btn-outline-secondary" href="/SEIR/public/admin/docentes">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</section>
