<?php
// Configuración ADMIN (solo lo necesario)
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<style>
  body{ background: linear-gradient(135deg, #0b1220, #f8fafc); min-height:100vh; }
  .page-wrap{ max-width: 980px; margin: 0 auto; }
  .soft-card{ border: 1px solid rgba(15,23,42,.08); border-radius: 18px; background: #fff; box-shadow: 0 18px 50px rgba(2,6,23,.08); }
</style>

<?php
$map = [];
foreach (($configs ?? []) as $c) {
  $map[$c['parametro']] = $c;
}

function cfg_val($map, $k, $default='') {
  return isset($map[$k]) ? (string)$map[$k]['valor'] : (string)$default;
}
function cfg_id($map, $k) {
  return isset($map[$k]) ? (int)$map[$k]['id_config'] : 0;
}

$sonidos = (int)cfg_val($map, 'sonidos_sistema', '1');
$offline = (int)cfg_val($map, 'modo_offline', '0');
?>

<div class="page-wrap py-4 px-3">
  <div class="d-flex justify-content-between align-items-center gap-2 mb-3">
    <div>
      <h3 class="mb-1">Configuración del sistema</h3>
      <div class="text-muted">Dejamos aquí solo lo que realmente usa el sistema.</div>
    </div>
    <a class="btn btn-outline-dark" href="/SEIR/public/dashboard">← Menú</a>
  </div>

  <?php if (!empty($ok)): ?>
    <div class="alert alert-success"><?= htmlspecialchars($ok) ?></div>
  <?php endif; ?>
  <?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <form method="post" action="/SEIR/public/admin/config/guardar">

    <input type="hidden" name="id_config[]" value="<?= cfg_id($map,'sonidos_sistema') ?>">
    <input type="hidden" name="valor[]" id="v_sonidos" value="<?= $sonidos ? '1' : '0' ?>">

    <input type="hidden" name="id_config[]" value="<?= cfg_id($map,'modo_offline') ?>">
    <input type="hidden" name="valor[]" id="v_offline" value="<?= $offline ? '1' : '0' ?>">

    <div class="soft-card p-3 p-md-4 mb-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="fw-semibold">Sonidos del sistema</div>
          <div class="text-muted">Efectos (correcto/incorrecto, alertas).</div>
        </div>
        <div class="form-check form-switch m-0">
          <input class="form-check-input" type="checkbox" id="sonidos" <?= $sonidos ? 'checked' : '' ?>>
        </div>
      </div>
    </div>

    <div class="soft-card p-3 p-md-4 mb-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="fw-semibold">Modo Offline (red local)</div>
          <div class="text-muted">Pensado para laboratorio: sin depender de internet.</div>
        </div>
        <div class="form-check form-switch m-0">
          <input class="form-check-input" type="checkbox" id="offline" <?= $offline ? 'checked' : '' ?>>
        </div>
      </div>
    </div>

    <div class="d-grid">
      <button class="btn btn-lg btn-primary">Guardar configuración</button>
    </div>
  </form>

  <div class="mt-3 small text-muted">
    <strong>Nota:</strong> el <em>tiempo del examen</em> y el <em>límite de estudiantes</em> ya no son configuración global.
    El tiempo lo define el docente al crear cada examen.
  </div>
</div>

<script>
  const sonidos = document.getElementById('sonidos');
  const offline = document.getElementById('offline');

  const vSonidos = document.getElementById('v_sonidos');
  const vOffline = document.getElementById('v_offline');

  sonidos.addEventListener('change', () => vSonidos.value = sonidos.checked ? '1' : '0');
  offline.addEventListener('change', () => vOffline.value = offline.checked ? '1' : '0');
</script>
