<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<style>
  body{ background: linear-gradient(135deg, #0b1220, #f8fafc); min-height:100vh; }
  .page-wrap{ max-width: 1200px; margin: 0 auto; }
  .soft-card{ border: 1px solid rgba(15,23,42,.08); border-radius: 18px; background: #fff; box-shadow: 0 18px 50px rgba(2,6,23,.08); }
  .table-wrapper { background: rgba(255,255,255,.80); border-radius: 18px; padding: 10px; box-shadow: 0 18px 50px rgba(0,0,0,.12); }
  .table thead th{ position: sticky; top: 0; background: #f8fafc; z-index: 1; }
  .mono { font-variant-numeric: tabular-nums; font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; }
</style>

<div class="container py-4">
  <div class="page-wrap">
    <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center gap-3 mb-3">
      <div>
        <h2 class="mb-0">Computadoras</h2>
        <div class="text-secondary">Supervisión básica (CU2): listado, estado y último ping (actividad real).</div>
      </div>
      <div class="d-flex gap-2">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalPc">
          + Registrar computadora
        </button>
        <a class="btn btn-outline-light" href="/SEIR/public/dashboard">Volver</a>
      </div>
    </div>

    <?php if (!empty($ok)): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($ok) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($error) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <div class="card soft-card overflow-hidden">
      <div class="card-body p-4">

        <div class="table-wrapper">
          <table class="table table-hover align-middle table-striped mb-0">
            <thead>
              <tr>
                <th>ID</th>
                <th>Código</th>
                <th>IP</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Último ping</th>
                <th>Creado</th>
                <th style="width:120px">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($pcs)): ?>
                <tr><td colspan="8" class="text-center text-secondary py-5">No hay computadoras registradas.</td></tr>
              <?php else: ?>
                <?php foreach ($pcs as $pc): ?>
                  <?php $estado = strtoupper(trim($pc['estado'] ?? '')); ?>
                  <tr>
                    <td class="mono fw-semibold"><?= (int)$pc['id_computadora'] ?></td>
                    <td class="mono"><?= htmlspecialchars($pc['codigo']) ?></td>
                    <td class="mono text-secondary"><?= htmlspecialchars($pc['ip'] ?? '—') ?></td>
                    <td><?= htmlspecialchars($pc['descripcion'] ?? '—') ?></td>
                    <td>
                    <?php if ($estado === 'OCUPADA'): ?>
                      <span class="badge rounded-pill text-bg-danger">OCUPADA</span>
                    <?php else: ?>
                      <span class="badge rounded-pill text-bg-success">LIBRE</span>
                      <?php endif; ?>
                    </td>
                    <td class="mono text-secondary"><?= htmlspecialchars($pc['ultimo_ping'] ?? '—') ?></td>
                    <td class="mono text-secondary"><?= htmlspecialchars($pc['created_at']) ?></td>
                    <td>
                      <div class="d-flex flex-wrap gap-2">
                        <a class="btn btn-sm btn-outline-primary" href="/SEIR/public/admin/computadoras/editar?id=<?= (int)$pc['id_computadora'] ?>">Editar</a>
                        <form method="post" action="/SEIR/public/admin/computadoras/eliminar" class="m-0" onsubmit="return confirm('¿Eliminar esta computadora?');">
                          <input type="hidden" name="id_computadora" value="<?= (int)$pc['id_computadora'] ?>">
                          <button type="submit" class="btn btn-sm btn-outline-danger">Eliminar</button>
                        </form>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>

        <div class="text-secondary small mt-3">
          Nota: el estado se calcula por actividad real del sistema (IP y sesiones). "Último ping" se actualiza cuando el estudiante se une o responde preguntas.
        </div>

        <!-- Modal: Registrar computadora -->
        <div class="modal fade" id="modalPc" tabindex="-1" aria-labelledby="modalPcLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <form method="post" action="/SEIR/public/admin/computadoras/crear">
                <div class="modal-header">
                  <h5 class="modal-title" id="modalPcLabel">Registrar computadora</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                  <div class="mb-3">
                    <label class="form-label">Código</label>
                    <input name="codigo" class="form-control" placeholder="PC-01" required>
                    <div class="form-text">Debe ser único (ej.: PC-01, LAB-A...).</div>
                  </div>

                  <div class="mb-3">
                    <label class="form-label">IP (opcional)</label>
                    <input name="ip" class="form-control" placeholder="192.168.1.50">
                  </div>

                  <div class="mb-3">
                    <label class="form-label">Descripción (opcional)</label>
                    <input name="descripcion" class="form-control" placeholder="Laboratorio 1 - Fila 2">
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                  <button type="submit" class="btn btn-success">Guardar</button>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
