<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script defer src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<style>
  body{ background: linear-gradient(135deg, #0b1220, #f8fafc); min-height:100vh; }
  .page-wrap{ max-width: 900px; margin: 0 auto; }
  .soft-card{ border: 1px solid rgba(15,23,42,.08); border-radius: 18px; background: #fff; box-shadow: 0 18px 50px rgba(2,6,23,.08); }
</style>

<?php
  $pc = $pc ?? [];
  $id = (int)($pc['id_computadora'] ?? 0);
  $codigo = htmlspecialchars($_POST['codigo'] ?? ($pc['codigo'] ?? ''));
  $ip = htmlspecialchars($_POST['ip'] ?? ($pc['ip'] ?? ''));
  $descripcion = htmlspecialchars($_POST['descripcion'] ?? ($pc['descripcion'] ?? ''));
?>

<div class="container py-4">
  <div class="page-wrap">

    <?php if (!empty($error)): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($error) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <div class="card soft-card overflow-hidden">
      <div class="card-body p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
          <div>
            <h3 class="mb-0">Editar computadora</h3>
            <div class="text-secondary">Actualiza código, IP o descripción.</div>
          </div>
          <a class="btn btn-outline-secondary" href="/SEIR/public/admin/computadoras">Volver</a>
        </div>

        <form method="post" action="/SEIR/public/admin/computadoras/editar" class="row g-3">
          <input type="hidden" name="id_computadora" value="<?= $id ?>">

          <div class="col-12">
            <label class="form-label">Código</label>
            <input class="form-control" name="codigo" required value="<?= $codigo ?>" placeholder="PC-01">
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label">IP (opcional)</label>
            <input class="form-control" name="ip" value="<?= $ip ?>" placeholder="192.168.1.50">
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label">Descripción (opcional)</label>
            <input class="form-control" name="descripcion" value="<?= $descripcion ?>" placeholder="Laboratorio 1 - Fila 2">
          </div>

          <div class="col-12 d-flex gap-2 pt-2">
            <button class="btn btn-success px-4" type="submit">Guardar cambios</button>
            <a class="btn btn-outline-secondary px-4" href="/SEIR/public/admin/computadoras">Cancelar</a>
          </div>

          <div class="col-12">
            <div class="alert alert-info mb-0">
              🔒 El estado <strong>LIBRE/OCUPADA</strong> se calcula automáticamente por actividad real (IP/sesión).
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
