<?php
declare(strict_types=1);

require_once APP_PATH . "/repositories/CursoRepository.php";

class CursoService
{
  private CursoRepository $repo;

  public function __construct()
  {
    $this->repo = new CursoRepository();
  }

  public function listar(int $idDocente): array
{
  return $this->repo->listarPorDocenteConConteo($idDocente);
}


  public function crear(int $idDocente, array $data): void
  {
    $nombre = trim((string)($data["nombre"] ?? ""));
    $desc   = trim((string)($data["descripcion"] ?? ""));

    if ($nombre === "") {
      throw new RuntimeException("El nombre del curso es obligatorio.");
    }
    if (mb_strlen($nombre) > 120) {
      throw new RuntimeException("Nombre muy largo (máx 120).");
    }
    if ($desc !== "" && mb_strlen($desc) > 255) {
      throw new RuntimeException("Descripción muy larga (máx 255).");
    }

    $this->repo->crear($idDocente, $nombre, $desc === "" ? null : $desc);
  }

  public function obtener(int $idDocente, int $idCurso): array
  {
    $c = $this->repo->obtener($idCurso, $idDocente);
    if (!$c) throw new RuntimeException("Curso no encontrado.");
    return $c;
  }

  public function actualizar(int $idDocente, int $idCurso, array $data): void
  {
    $nombre = trim((string)($data["nombre"] ?? ""));
    $desc   = trim((string)($data["descripcion"] ?? ""));

    if ($nombre === "") {
      throw new RuntimeException("El nombre del curso es obligatorio.");
    }

    // valida existencia
    $this->obtener($idDocente, $idCurso);

    $this->repo->actualizar($idCurso, $idDocente, $nombre, $desc === "" ? null : $desc);
  }

  public function eliminar(int $idDocente, int $idCurso): void
  {
    $this->obtener($idDocente, $idCurso);
    $this->repo->eliminar($idCurso, $idDocente);
  }

  public function toggleEstado(int $idDocente, int $idCurso): void
  {
    $this->obtener($idDocente, $idCurso);
    $this->repo->toggleEstado($idCurso, $idDocente);
  }
}
