<?php
declare(strict_types=1);

class AuthService {
  private UsuarioRepository $repo;

  public function __construct() {
    require_once APP_PATH . "/repositories/UsuarioRepository.php";
    $this->repo = new UsuarioRepository();
  }

  public function login(string $username, string $password): array {
    $username = trim($username);

    if ($username === "" || $password === "") {
      throw new Exception("Completa usuario y contraseña.");
    }

    $u = $this->repo->findByUsername($username);
    if (!$u) {
      throw new Exception("Usuario o contraseña incorrectos.");
    }

    if (strtoupper($u["estado"]) !== "ACTIVO") {
      throw new Exception("Usuario inactivo.");
    }

    if (!password_verify($password, $u["password_hash"])) {
      throw new Exception("Usuario o contraseña incorrectos.");
    }

    $rol = $this->repo->getRol((int)$u["id_usuario"]);
    $u["rol"] = $rol;

    // datos que guardaremos en sesión (sin password_hash)
    return [
      "id_usuario" => (int)$u["id_usuario"],
      "username"   => $u["username"],
      "nombres"    => $u["nombres"],
      "apellidos"  => $u["apellidos"],
      "rol"        => $u["rol"]
    ];
  }
}
