<?php
declare(strict_types=1);

class AdminConfigService {
  private ConfigRepository $repo;

  public function __construct() {
    require_once APP_PATH . "/repositories/ConfigRepository.php";
    $this->repo = new ConfigRepository();
  }

  public function listar(): array {
    return $this->repo->listAll();
  }

  /**
   * Guarda cambios masivos enviados desde el form.
   * Espera arrays: id_config[] y valor[]
   */
  public function guardar(array $data): void {
    $ids = $data['id_config'] ?? [];
    $valores = $data['valor'] ?? [];
    if (!is_array($ids) || !is_array($valores)) {
      throw new Exception('Datos inválidos.');
    }
    if (count($ids) !== count($valores)) {
      throw new Exception('Datos incompletos.');
    }

    for ($i=0; $i<count($ids); $i++) {
      $id = (int)$ids[$i];
      $valor = trim((string)$valores[$i]);
      if ($id > 0) {
        $this->repo->updateValor($id, $valor);
      }
    }
  }
}
