<?php
declare(strict_types=1);

class AdminComputadoraService {
  private ComputadoraRepository $repo;

  public function __construct() {
    require_once APP_PATH . "/repositories/ComputadoraRepository.php";
    $this->repo = new ComputadoraRepository();
  }

  public function listar(): array {
    return $this->repo->listAll();
  }

  public function crear(string $codigo, ?string $ip, ?string $descripcion): int {
    return $this->repo->create($codigo, $ip, $descripcion);
  }

  public function eliminar(int $id): void {
    $this->repo->deleteById($id);
  }

  public function obtener(int $id): array {
    $pc = $this->repo->findById($id);
    if (!$pc) throw new Exception('Computadora no encontrada.');
    return $pc;
  }

  public function actualizar(int $id, string $codigo, ?string $ip, ?string $descripcion): void {
    $this->repo->updateById($id, $codigo, $ip, $descripcion);
  }

  public function toggleEstado(int $id, string $estadoActual): void {
    if ($id <= 0) throw new Exception('Computadora inválida.');
    throw new Exception('El estado se calcula por actividad real (LIBRE/OCUPADA).');
  }

  public function marcarPing(int $id): void {
    if ($id <= 0) throw new Exception('Computadora inválida.');
    // El monitoreo es por actividad real. Este método ya no se usa.
    throw new Exception('Ping manual deshabilitado: el estado se actualiza automáticamente.');
  }
}
