<?php
declare(strict_types=1);

class UsuarioRepository {
  public function findByUsername(string $username): ?array {
    $pdo = db();
    $st = $pdo->prepare("
      SELECT id_usuario, nombres, apellidos, username, password_hash, estado
      FROM usuario
      WHERE username = ?
      LIMIT 1
    ");
    $st->execute([$username]);
    $row = $st->fetch();
    return $row ?: null;
  }

  public function getRol(int $idUsuario): string {
    $pdo = db();

    // Importante: un usuario puede pertenecer a un rol (según tu BD)
    $st = $pdo->prepare("SELECT 1 FROM administrador WHERE id_usuario=? LIMIT 1");
    $st->execute([$idUsuario]);
    if ($st->fetch()) return "ADMIN";

    $st = $pdo->prepare("SELECT 1 FROM docente WHERE id_usuario=? LIMIT 1");
    $st->execute([$idUsuario]);
    if ($st->fetch()) return "DOCENTE";

    $st = $pdo->prepare("SELECT 1 FROM estudiante WHERE id_usuario=? LIMIT 1");
    $st->execute([$idUsuario]);
    if ($st->fetch()) return "ESTUDIANTE";

    return "USER";
  }
}
