<?php
declare(strict_types=1);

class ResultadoRepository {
  public function getRankingPartida(int $idPartida): array {
    $pdo = db();
    // Si no tienes vista, usamos SQL directo:
    $st = $pdo->prepare("
      SELECT p.alias,
             u.nombres,
             u.apellidos,
             COALESCE(SUM(r.puntaje_obtenido),0) AS puntaje_total,
             COUNT(r.id_respuesta) AS respuestas
      FROM participante p
      JOIN estudiante e ON e.id_usuario = p.id_estudiante
      JOIN usuario u ON u.id_usuario = e.id_usuario
      LEFT JOIN respuesta r ON r.id_participante = p.id_participante
      LEFT JOIN partida_pregunta pp ON pp.id = r.id_partida_pregunta
      WHERE p.id_partida = ?
      GROUP BY p.id_participante, p.alias, u.nombres, u.apellidos
      ORDER BY puntaje_total DESC, respuestas DESC, p.alias ASC
    ");
    $st->execute([$idPartida]);
    return $st->fetchAll();
  }
public function listByUsuario(int $idUsuario): array {
  $pdo = db();

  // Resumen por partida para el estudiante (puntaje total + fecha + ranking logrado)
  // Nota: requiere MySQL 8+ (window functions). Si tu MySQL es antiguo, se puede calcular en PHP.
  $sql = "
    SELECT
      pa.id_partida,
      CONCAT(pa.titulo, ' (', pa.codigo, ')') AS partida,
      t.puntaje_total,
      t.fecha,
      CONCAT(rnk.posicion, ' de ', rnk.total_participantes) AS ranking_logrado
    FROM (
      SELECT
        p.id_partida,
        p.id_estudiante,
        COALESCE(SUM(r.puntaje_obtenido),0) AS puntaje_total,
        MAX(COALESCE(pa.fecha_fin, pa.fecha_inicio, pa.created_at)) AS fecha
      FROM participante p
      JOIN partida pa ON pa.id_partida = p.id_partida
      LEFT JOIN respuesta r ON r.id_participante = p.id_participante
      WHERE p.id_estudiante = ?
      GROUP BY p.id_partida, p.id_estudiante
    ) t
    JOIN partida pa ON pa.id_partida = t.id_partida
    JOIN (
      SELECT
        s.id_partida,
        s.id_estudiante,
        DENSE_RANK() OVER (PARTITION BY s.id_partida ORDER BY s.puntaje_total DESC) AS posicion,
        COUNT(*) OVER (PARTITION BY s.id_partida) AS total_participantes
      FROM (
        SELECT
          p.id_partida,
          p.id_estudiante,
          COALESCE(SUM(r.puntaje_obtenido),0) AS puntaje_total
        FROM participante p
        LEFT JOIN respuesta r ON r.id_participante = p.id_participante
        GROUP BY p.id_partida, p.id_estudiante
      ) s
    ) rnk ON rnk.id_partida = t.id_partida AND rnk.id_estudiante = t.id_estudiante
    ORDER BY t.fecha DESC, pa.id_partida DESC
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$idUsuario]);
  return $st->fetchAll();
}
}
