<?php
declare(strict_types=1);

class ParticipanteRepository {

  public function findByPartidaAndEstudiante(int $idPartida, int $idEstudiante): ?array {
    $pdo = db();
    $st = $pdo->prepare(
      "SELECT id_participante, alias, fecha_union,
              COALESCE(finalizado,0) AS finalizado,
              finalizado_at
       FROM participante
       WHERE id_partida = ? AND id_estudiante = ?
       LIMIT 1"
    );
    $st->execute([$idPartida, $idEstudiante]);
    $row = $st->fetch();
    return $row ?: null;
  }

  public function aliasExisteEnPartida(int $idPartida, string $alias): bool {
    $pdo = db();
    $st = $pdo->prepare("SELECT 1 FROM participante WHERE id_partida=? AND alias=? LIMIT 1");
    $st->execute([$idPartida, $alias]);
    return (bool)$st->fetch();
  }

  public function create(int $idPartida, int $idEstudiante, string $alias): int {
    $pdo = db();
    $st = $pdo->prepare(
      "INSERT INTO participante (id_partida, id_estudiante, alias)
       VALUES (?, ?, ?)"
    );
    $st->execute([$idPartida, $idEstudiante, $alias]);
    return (int)$pdo->lastInsertId();
  }

  public function setFinalizado(int $idParticipante): void {
    $pdo = db();
    $st = $pdo->prepare("UPDATE participante SET finalizado=1, finalizado_at=NOW() WHERE id_participante=?");
    $st->execute([$idParticipante]);
  }

  public function isFinalizado(int $idParticipante): bool {
    $pdo = db();
    $st = $pdo->prepare("SELECT COALESCE(finalizado,0) f FROM participante WHERE id_participante=? LIMIT 1");
    $st->execute([$idParticipante]);
    $row = $st->fetch();
    return $row ? ((int)$row['f'] === 1) : false;
  }


  public function findById(int $idParticipante): ?array {
    $pdo = db();
    $st = $pdo->prepare("SELECT * FROM participante WHERE id_participante = ? LIMIT 1");
    $st->execute([$idParticipante]);
    $row = $st->fetch();
    return $row ?: null;
  }

  // Alias por compatibilidad con parches anteriores (crear == create)
  public function crear(int $idPartida, int $idEstudiante, string $alias): int {
    return $this->create($idPartida, $idEstudiante, $alias);
  }

}
