<?php
declare(strict_types=1);

class EstudianteRepository {

  public function getAll(): array {
    $pdo = db();
    $st = $pdo->query("
      SELECT e.id_usuario, e.dni, e.grado, e.seccion,
             u.nombres, u.apellidos, u.username, u.estado, u.created_at
      FROM estudiante e
      JOIN usuario u ON u.id_usuario = e.id_usuario
      ORDER BY u.created_at DESC
    ");
    return $st->fetchAll();
  }

  public function getByUsuarioId(int $idUsuario): ?array {
    $pdo = db();
    $st = $pdo->prepare("
      SELECT e.id_usuario, e.dni, e.grado, e.seccion,
             u.nombres, u.apellidos, u.username, u.estado, u.created_at
      FROM estudiante e
      JOIN usuario u ON u.id_usuario = e.id_usuario
      WHERE e.id_usuario = ?
      LIMIT 1
    ");
    $st->execute([$idUsuario]);
    $row = $st->fetch();
    return $row ?: null;
  }

  public function existsDni(string $dni): bool {
    $pdo = db();
    $st = $pdo->prepare("SELECT 1 FROM estudiante WHERE dni = ? LIMIT 1");
    $st->execute([$dni]);
    return (bool)$st->fetch();
  }

  public function existsUsername(string $username): bool {
    $pdo = db();
    $st = $pdo->prepare("SELECT 1 FROM usuario WHERE username = ? LIMIT 1");
    $st->execute([$username]);
    return (bool)$st->fetch();
  }

  public function createUser(string $nombres, string $apellidos, string $username, string $passwordHash): int {
    $pdo = db();
    $st = $pdo->prepare("
      INSERT INTO usuario (nombres, apellidos, username, password_hash, estado)
      VALUES (?, ?, ?, ?, 'ACTIVO')
    ");
    $st->execute([$nombres, $apellidos, $username, $passwordHash]);
    return (int)$pdo->lastInsertId();
  }

  public function createEstudiante(int $idUsuario, string $dni, string $grado, string $seccion): void {
    $pdo = db();
    $st = $pdo->prepare("
      INSERT INTO estudiante (id_usuario, dni, grado, seccion)
      VALUES (?, ?, ?, ?)
    ");
    $st->execute([$idUsuario, $dni, $grado, $seccion]);
  }

  public function updateUser(int $idUsuario, string $nombres, string $apellidos, string $username, string $estado): void {
    $pdo = db();
    $st = $pdo->prepare("
      UPDATE usuario
      SET nombres=?, apellidos=?, username=?, estado=?
      WHERE id_usuario=?
      LIMIT 1
    ");
    $st->execute([$nombres, $apellidos, $username, $estado, $idUsuario]);
  }

  public function updateEstudiante(int $idUsuario, string $dni, string $grado, string $seccion): void {
    $pdo = db();
    $st = $pdo->prepare("
      UPDATE estudiante
      SET dni=?, grado=?, seccion=?
      WHERE id_usuario=?
      LIMIT 1
    ");
    $st->execute([$dni, $grado, $seccion, $idUsuario]);
  }

  public function deleteEstudiante(int $idUsuario): void {
    $pdo = db();
    $st = $pdo->prepare("DELETE FROM estudiante WHERE id_usuario=? LIMIT 1");
    $st->execute([$idUsuario]);
  }

  public function deleteUsuario(int $idUsuario): void {
    $pdo = db();
    $st = $pdo->prepare("DELETE FROM usuario WHERE id_usuario=? LIMIT 1");
    $st->execute([$idUsuario]);
  }
}
