<?php
declare(strict_types=1);

class CursoRepository
{
  public function listarPorDocenteConConteo(int $idDocente): array
{
  $pdo = db();
  $st = $pdo->prepare("
    SELECT 
      c.id_curso,
      c.nombre,
      c.descripcion,
      c.activo,
      c.created_at,
      COUNT(p.id_pregunta) AS total_preguntas
    FROM curso c
    LEFT JOIN pregunta p 
      ON p.id_curso = c.id_curso
      AND p.id_docente = c.id_docente
    WHERE c.id_docente = ?
    GROUP BY c.id_curso
    ORDER BY c.created_at DESC
  ");
  $st->execute([$idDocente]);
  return $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
}


  public function crear(int $idDocente, string $nombre, ?string $descripcion): void
  {
    $pdo = db();
    $st = $pdo->prepare("
      INSERT INTO curso (id_docente, nombre, descripcion)
      VALUES (:id_docente, :nombre, :descripcion)
    ");
    $st->execute([
      ":id_docente" => $idDocente,
      ":nombre" => $nombre,
      ":descripcion" => $descripcion
    ]);
  }

  public function obtener(int $idCurso, int $idDocente): ?array
  {
    $pdo = db();
    $st = $pdo->prepare("SELECT * FROM curso WHERE id_curso = :id AND id_docente = :doc LIMIT 1");
    $st->execute([":id" => $idCurso, ":doc" => $idDocente]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    return $row ?: null;
  }

  public function actualizar(int $idCurso, int $idDocente, string $nombre, ?string $descripcion): void
  {
    $pdo = db();
    $st = $pdo->prepare("
      UPDATE curso
      SET nombre = :nombre, descripcion = :descripcion
      WHERE id_curso = :id AND id_docente = :doc
    ");
    $st->execute([
      ":nombre" => $nombre,
      ":descripcion" => $descripcion,
      ":id" => $idCurso,
      ":doc" => $idDocente
    ]);
  }

  public function eliminar(int $idCurso, int $idDocente): void
  {
    $pdo = db();
    $st = $pdo->prepare("DELETE FROM curso WHERE id_curso = :id AND id_docente = :doc");
    $st->execute([":id" => $idCurso, ":doc" => $idDocente]);
  }

  public function toggleEstado(int $idCurso, int $idDocente): void
  {
    $pdo = db();
    $st = $pdo->prepare("
      UPDATE curso
      SET activo = IF(activo=1,0,1)
      WHERE id_curso = :id AND id_docente = :doc
    ");
    $st->execute([":id" => $idCurso, ":doc" => $idDocente]);
  }

  public function findByIdAndDocente(int $idCurso, int $idDocente): ?array {
  $pdo = db();
  $st = $pdo->prepare("SELECT * FROM curso WHERE id_curso = ? AND id_docente = ? LIMIT 1");
  $st->execute([$idCurso, $idDocente]);
  $row = $st->fetch();
  return $row ?: null;
}
  

}
