<?php
declare(strict_types=1);

class ConfigRepository {

  public function listAll(): array {
    $pdo = db();

    // Seed inicial: creamos parámetros base si la tabla está vacía.
    $count = (int)$pdo->query("SELECT COUNT(*) FROM configuracion")->fetchColumn();
    if ($count === 0) {
      $stIns = $pdo->prepare(
        "INSERT INTO configuracion (parametro, valor, descripcion) VALUES (?, ?, ?)"
      );

      $defaults = [
        // UI / laboratorio
        ['sonidos_sistema', '1', 'Activa/desactiva sonidos del sistema.'],
        ['modo_offline', '0', 'Modo offline (uso en red local).'],

        // Límites / control
        ['max_preguntas_partida', '10', 'Límite de preguntas por partida.'],
        ['max_intentos_unirse', '3', 'Máximo de intentos al unirse con código (anti-spam simple).'],

        // Mensajes
        ['mensaje_bienvenida', 'Bienvenido(a) a SEIR', 'Mensaje general de bienvenida en el sistema.'],

        // Preguntas compartidas
        ['preguntas_compartidas', '0', '0=Privadas por docente, 1=Permite preguntas compartidas (públicas).'],
      ];

      foreach ($defaults as $d) {
        $stIns->execute($d);
      }
    }

    $st = $pdo->query(
      "SELECT id_config, parametro, valor, descripcion, updated_at
       FROM configuracion
       ORDER BY parametro ASC"
    );
    return $st->fetchAll();
  }

  public function updateValor(int $idConfig, string $valor): void {
    $pdo = db();
    $st = $pdo->prepare("UPDATE configuracion SET valor=? WHERE id_config=?");
    $st->execute([$valor, $idConfig]);
  }
}
