<?php
declare(strict_types=1);

class View {
  public static function render(string $view, array $data = []): void {
    extract($data);

    $view = ltrim($view, '/');
    $header = VIEW_PATH . "/layout/header.php";
    $footer = VIEW_PATH . "/layout/footer.php";
    $file   = VIEW_PATH . "/{$view}.php";

    if (is_file($header)) {
      require $header;
    }

    if (is_file($file)) {
      require $file;
    } else {
      http_response_code(404);
      echo "<h2 style='padding:20px'>Vista no encontrada: " . htmlspecialchars($view) . "</h2>";
    }

    if (is_file($footer)) {
      require $footer;
    }
  }
}
