<?php
declare(strict_types=1);

class Router {
  private array $routes = ['GET'=>[], 'POST'=>[]];

  public function get(string $path, array $handler): void { $this->routes['GET'][$path] = $handler; }
  public function post(string $path, array $handler): void { $this->routes['POST'][$path] = $handler; }

  public function dispatch(): void {
    $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
    $uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);

    // si tu proyecto es /SEIR, recortamos el prefijo
    $base = '/SEIR/public';
    if (str_starts_with($uri, $base)) $uri = substr($uri, strlen($base));
    if ($uri === '') $uri = '/';

    $handler = $this->routes[$method][$uri] ?? null;
    if (!$handler) { http_response_code(404); echo "404 - Ruta no encontrada"; return; }

    [$class, $action] = $handler;
    require_once APP_PATH . "/controllers/$class.php";
    $controller = new $class();
    $controller->$action();
  }
}
