<?php
declare(strict_types=1);

class Auth {
  public static function start(): void {
    if (session_status() === PHP_SESSION_NONE) {
      session_start();
    }
  }

  public static function login(array $user): void {
    self::start();

    // Normaliza roles para evitar 403 por valores distintos en BD.
    // Acepta variantes comunes: ADMINISTRADOR/ADMIN, PROFESOR/DOCENTE, ALUMNO/ESTUDIANTE.
    $rolRaw = (string)($user['rol'] ?? 'USER');
    $rol = strtoupper(trim($rolRaw));
    $map = [
      'ADMINISTRADOR' => 'ADMIN',
      'ADMIN'         => 'ADMIN',
      'DOCENTE'       => 'DOCENTE',
      'PROFESOR'      => 'DOCENTE',
      'ESTUDIANTE'    => 'ESTUDIANTE',
      'ALUMNO'        => 'ESTUDIANTE',
      'USER'          => 'USER',
    ];
    $rol = $map[$rol] ?? $rol;

    $_SESSION['user'] = [
      'id_usuario' => (int)$user['id_usuario'],
      'username'   => $user['username'],
      'nombres'    => $user['nombres'],
      'apellidos'  => $user['apellidos'],
      'rol'        => $rol // ADMIN / DOCENTE / ESTUDIANTE
    ];
  }

  public static function user(): ?array {
    self::start();
    return $_SESSION['user'] ?? null;
  }

  public static function check(): bool {
    return self::user() !== null;
  }

  public static function requireLogin(): void {
    if (!self::check()) {
      header("Location: /SEIR/public/"); exit;
    }
  }

  public static function logout(): void {
    self::start();
    session_unset();
    session_destroy();
  }
}
