<?php
declare(strict_types=1);

require_once APP_PATH . "/services/ParticipacionService.php";
require_once APP_PATH . "/repositories/PartidaRepository.php";

class ParticipacionController extends Controller {

  private function requireEstudiante(): void {
    Auth::requireLogin();
    $u = Auth::user();
    if (($u['rol'] ?? '') !== 'ESTUDIANTE') {
      http_response_code(403);
      echo "403 - Solo estudiantes";
      exit;
    }
  }

  public function unirseForm(): void {
    $this->requireEstudiante();
    $this->view("participacion/unirse", [
      "error" => $_GET["error"] ?? ""
    ]);
  }

  public function unirse(): void {
    $this->requireEstudiante();

    try {
      $u = Auth::user();
      $idEst = (int)$u['id_usuario'];

      $codigo = $_POST['codigo'] ?? '';
      $alias = $_POST['alias'] ?? '';

      $ip = $_SERVER['REMOTE_ADDR'] ?? '';

      $service = new ParticipacionService();
      $data = $service->unirse($idEst, $codigo, $alias, $ip);

      Auth::start();
      $_SESSION['quiz'] = [
        "id_partida" => (int)$data["partida"]["id_partida"],
        "codigo" => $data["partida"]["codigo"],
        "titulo" => $data["partida"]["titulo"],
        "estado" => $data["partida"]["estado"],
        "id_participante" => (int)$data["participante"]["id_participante"],
        "alias" => $data["participante"]["alias"],
        "ip" => $data["ip"] ?? ($ip ?? "")
      ];

      $this->redirect("/SEIR/public/sala");
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/unirse?error=" . urlencode($e->getMessage()));
    }
  }

  public function sala(): void {
    $this->requireEstudiante();
    Auth::start();
    $quiz = $_SESSION['quiz'] ?? null;

    if (!$quiz) {
      $this->redirect("/SEIR/public/unirse?error=" . urlencode("Primero debes unirte a una partida."));
    }

    $estado = (new PartidaRepository())->getEstadoById((int)$quiz['id_partida']);
    $quiz['estado'] = $estado ?? ($quiz['estado'] ?? 'CREADA');
    $_SESSION['quiz']['estado'] = $quiz['estado'];

    if ($quiz['estado'] === 'EN_CURSO') {
      $this->redirect("/SEIR/public/quiz");
    }

    $this->view("participacion/sala", [
      "quiz" => $quiz
    ]);
  }

  /** Endpoint JSON para polling desde la sala de espera */
  public function estado(): void {
    $this->requireEstudiante();
    Auth::start();
    header('Content-Type: application/json; charset=utf-8');

    $quiz = $_SESSION['quiz'] ?? null;
    if (!$quiz) {
      echo json_encode(["ok" => false, "error" => "no_session"]);
      return;
    }

    $estado = (new PartidaRepository())->getEstadoById((int)$quiz['id_partida']);
    $estado = $estado ?? ($quiz['estado'] ?? 'CREADA');
    $_SESSION['quiz']['estado'] = $estado;

    echo json_encode([
      "ok" => true,
      "estado" => $estado,
      "id_partida" => (int)$quiz['id_partida']
    ]);
  }
}
