<?php
declare(strict_types=1);

require_once APP_PATH . "/services/EstudianteService.php";

class EstudianteController extends Controller {

  private function requireDocenteAdmin(): void {
    Auth::requireLogin();
    $u = Auth::user();
    $rol = strtoupper(trim((string)($u['rol'] ?? '')));
    if (!in_array($rol, ['DOCENTE','ADMIN','PROFESOR','ADMINISTRADOR'], true)) {
      http_response_code(403);
      echo "403 - No autorizado";
      exit;
    }
  }

  public function index(): void {
    $this->requireDocenteAdmin();
    $service = new EstudianteService();

    $this->view("estudiantes/index", [
      "title" => "SEIR • Estudiantes",
      "pageCss" => "/SEIR/public/assets/css/pages/estudiantes.css",
      "estudiantes" => $service->listar(),
      "ok" => $_GET["ok"] ?? "",
      "error" => $_GET["error"] ?? ""
    ]);
  }

  public function createForm(): void {
    $this->requireDocenteAdmin();
    $this->view("estudiantes/create", [
      "title" => "SEIR • Registrar estudiante",
      "pageCss" => "/SEIR/public/assets/css/pages/estudiantes.css",
      "error" => $_GET["error"] ?? ""
    ]);
  }

  public function store(): void {
    $this->requireDocenteAdmin();

    try {
      $service = new EstudianteService();
      $service->registrar($_POST);

      $this->redirect("/SEIR/public/estudiantes?ok=" . urlencode("Estudiante registrado. Usuario=DNI, clave inicial=DNI"));
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/estudiantes/crear?error=" . urlencode($e->getMessage()));
    }
  }

  public function editForm(): void {
    $this->requireDocenteAdmin();
    $id = (int)($_GET['id'] ?? 0);

    try {
      $service = new EstudianteService();
      $e = $service->obtener($id);

      $this->view('estudiantes/edit', [
        "title" => "SEIR • Editar estudiante",
        "pageCss" => "/SEIR/public/assets/css/pages/estudiantes.css",
        'e' => $e,
        'error' => $_GET['error'] ?? '',
      ]);
    } catch (Throwable $ex) {
      $this->redirect('/SEIR/public/estudiantes?error=' . urlencode($ex->getMessage()));
    }
  }

  public function update(): void {
    $this->requireDocenteAdmin();
    $id = (int)($_POST['id_usuario'] ?? 0);

    try {
      $service = new EstudianteService();
      $service->actualizar($id, $_POST);
      $this->redirect('/SEIR/public/estudiantes?ok=' . urlencode('Estudiante actualizado.'));
    } catch (Throwable $ex) {
      $this->redirect('/SEIR/public/estudiantes/editar?id=' . $id . '&error=' . urlencode($ex->getMessage()));
    }
  }

  public function destroy(): void {
    $this->requireDocenteAdmin();
    $id = (int)($_POST['id_usuario'] ?? 0);

    try {
      $service = new EstudianteService();
      $service->eliminar($id);
      $this->redirect('/SEIR/public/estudiantes?ok=' . urlencode('Estudiante eliminado.'));
    } catch (Throwable $ex) {
      $this->redirect('/SEIR/public/estudiantes?error=' . urlencode($ex->getMessage()));
    }
  }
}
