<?php
declare(strict_types=1);

require_once APP_PATH . "/services/CursoService.php";

class CursoController extends Controller
{
  private function requireDocente(): array
  {
    Auth::requireLogin();
    $u = Auth::user();
    if (($u["rol"] ?? "") !== "DOCENTE") {
      http_response_code(403);
      echo "403 - No autorizado";
      exit;
    }
    return $u;
  }

  private function meta(string $title): array
  {
    return [
      "title"   => $title,
      "pageCss" => "/SEIR/public/assets/css/pages/cursos.css",
    ];
  }

  public function index(): void
{
  $u = $this->requireDocente();
  $service = new CursoService();

  $this->view("cursos/index", array_merge(
    $this->meta("SEIR • Cursos"),
    [
      "cursos" => $service->listar((int)$u["id_usuario"]),
      "ok"     => $_GET["ok"] ?? "",
      "error"  => $_GET["error"] ?? ""
    ]
  ));
}


  public function createForm(): void
  {
    $this->requireDocente();
    $this->view("cursos/create", array_merge(
      $this->meta("SEIR • Nuevo curso"),
      [ "error" => $_GET["error"] ?? "" ]
    ));
  }

  public function store(): void
  {
    $u = $this->requireDocente();
    try {
      (new CursoService())->crear((int)$u["id_usuario"], $_POST);
      $this->redirect("/SEIR/public/cursos?ok=" . urlencode("Curso creado correctamente."));
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/cursos/crear?error=" . urlencode($e->getMessage()));
    }
  }

  public function editForm(): void
  {
    $u = $this->requireDocente();
    $id = (int)($_GET["id"] ?? 0);
    if ($id <= 0) $this->redirect("/SEIR/public/cursos?error=" . urlencode("ID inválido"));

    try {
      $curso = (new CursoService())->obtener((int)$u["id_usuario"], $id);
      $this->view("cursos/edit", array_merge(
        $this->meta("SEIR • Editar curso"),
        [ "c" => $curso, "error" => $_GET["error"] ?? "" ]
      ));
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/cursos?error=" . urlencode($e->getMessage()));
    }
  }

  public function update(): void
  {
    $u = $this->requireDocente();
    $id = (int)($_POST["id_curso"] ?? 0);
    if ($id <= 0) $this->redirect("/SEIR/public/cursos?error=" . urlencode("ID inválido"));

    try {
      (new CursoService())->actualizar((int)$u["id_usuario"], $id, $_POST);
      $this->redirect("/SEIR/public/cursos?ok=" . urlencode("Curso actualizado."));
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/cursos/editar?id=$id&error=" . urlencode($e->getMessage()));
    }
  }

  public function destroy(): void
  {
    $u = $this->requireDocente();
    $id = (int)($_POST["id_curso"] ?? 0);

    try {
      (new CursoService())->eliminar((int)$u["id_usuario"], $id);
      $this->redirect("/SEIR/public/cursos?ok=" . urlencode("Curso eliminado."));
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/cursos?error=" . urlencode($e->getMessage()));
    }
  }

  public function toggleEstado(): void
  {
    $u = $this->requireDocente();
    $id = (int)($_POST["id_curso"] ?? 0);

    try {
      (new CursoService())->toggleEstado((int)$u["id_usuario"], $id);
      $this->redirect("/SEIR/public/cursos?ok=" . urlencode("Estado actualizado."));
    } catch (Throwable $e) {
      $this->redirect("/SEIR/public/cursos?error=" . urlencode($e->getMessage()));
    }
  }

public function entrar(): void
{
  $u = $this->requireDocente();
  $idDocente = (int)$u['id_usuario'];

  $idCurso = (int)($_GET['id'] ?? 0);
  if ($idCurso <= 0) {
    $this->redirect("/SEIR/public/cursos");
    return;
  }

  $service = new CursoService();

  try {
    $curso = $service->obtener($idDocente, $idCurso);

    $this->view("cursos/entrar", [
      "title"   => "SEIR • Curso",
      "pageCss" => "/SEIR/public/assets/css/pages/curso-detalle.css",
      "curso"   => $curso
    ]);
  } catch (Throwable $e) {
    $this->view("cursos/index", [
      "title"   => "SEIR • Cursos",
      "pageCss" => "/SEIR/public/assets/css/pages/cursos.css",
      "error"   => "Curso no encontrado o no te pertenece.",
      "cursos"  => $service->listar($idDocente),
      "ok"      => ""
    ]);
  }
}
  
  
}
