<?php
declare(strict_types=1);

require_once APP_PATH . "/services/AuthService.php";

require_once APP_PATH . "/repositories/ComputadoraRepository.php";

class AuthController extends Controller {

  public function loginForm(): void {
    
    if (Auth::check()) {
      $this->redirect("/SEIR/public/dashboard");
    }

    $this->view("auth/login", [
      "error" => $_GET["error"] ?? ""
    ]);
  }

  public function login(): void {
    try {
      $service = new AuthService();

      $username = $_POST["username"] ?? "";
      $password = $_POST["password"] ?? "";

      $userSession = $service->login($username, $password);
      Auth::login($userSession);

      $this->redirect("/SEIR/public/dashboard");

    } catch (Throwable $e) {
      $msg = urlencode($e->getMessage());
      $this->redirect("/SEIR/public/?error=$msg");
    }
  }

public function dashboard(): void
{
  Auth::requireLogin();

  $user = Auth::user();
  $rol  = $user['rol'] ?? '';
  $pdo  = db();

  $metrics = [];

  /* =========================
     METRICAS ADMIN
     ========================= */
  if ($rol === 'ADMIN') {

  $metrics['docentes_activos'] = (int)$pdo->query("
    SELECT COUNT(*)
    FROM docente d
    JOIN usuario u ON u.id_usuario = d.id_usuario
    WHERE u.estado = 'ACTIVO'
  ")->fetchColumn();

  // ✅ TOTAL docentes registrados (así tengas 2)
  $metrics['docentes_total'] = (int)$pdo->query("SELECT COUNT(*) FROM docente")->fetchColumn();

  // ✅ TOTAL estudiantes registrados
  $metrics['estudiantes'] = (int)$pdo->query("SELECT COUNT(*) FROM estudiante")->fetchColumn();

  $metrics['equipos'] = (int)$pdo->query("SELECT COUNT(*) FROM computadora")->fetchColumn();
  $metrics['sistema'] = 'Óptimo';
}


  /* =========================
     METRICAS DOCENTE
     ========================= */
  if ($rol === 'DOCENTE') {

    // ✅ En tu BD, docente.id_usuario = usuario.id_usuario
    // Si no guardas id_docente en sesión, usamos id_usuario
    $idDocente = (int)($user['id_docente'] ?? ($user['id_usuario'] ?? 0));

    // evaluaciones (partidas)
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM partida WHERE id_docente = :id");
    $stmt->execute([':id' => $idDocente]);
    $metrics['evaluaciones'] = (int)$stmt->fetchColumn();

    // preguntas
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM pregunta WHERE id_docente = :id");
    $stmt->execute([':id' => $idDocente]);
    $metrics['preguntas'] = (int)$stmt->fetchColumn();

    // estudiantes (global)
    $metrics['estudiantes'] = (int)$pdo->query("SELECT COUNT(*) FROM estudiante")->fetchColumn();

    // ✅ Promedio % de aciertos (respuesta.puntaje_obtenido es 0/1)
    $stmt = $pdo->prepare("
      SELECT ROUND(100 * AVG(r.puntaje_obtenido), 1)
      FROM respuesta r
      JOIN participante par ON par.id_participante = r.id_participante
      JOIN partida p ON p.id_partida = par.id_partida
      WHERE p.id_docente = :id
    ");
    $stmt->execute([':id' => $idDocente]);
    $avgPct = $stmt->fetchColumn();

    $metrics['promedio'] = ($avgPct === false || $avgPct === null) ? '—' : $avgPct; // ej: 60.0
  }

  $this->view("dashboard/index", [
    "title"   => "SEIR • Dashboard",
    "pageCss" => "/SEIR/public/assets/css/pages/dashboard.css",
    "user"    => $user,
    "metrics" => $metrics
  ]);
}





  public function logout(): void {
    Auth::start();
    $u = $_SESSION['user'] ?? null;
    $quiz = $_SESSION['quiz'] ?? null;

    // Si es estudiante y estaba usando una PC registrada, la liberamos al salir
    if ($u && (($u['rol'] ?? '') === 'ESTUDIANTE')) {
      $ip = $quiz['ip'] ?? ($_SERVER['REMOTE_ADDR'] ?? '');
      if ($ip !== '') {
        try { (new ComputadoraRepository())->liberarByIp($ip); } catch (Throwable $e) {}
      }
    }

    Auth::logout();
    $this->redirect("/SEIR/public/");
  }
}
