<?php
declare(strict_types=1);

require_once APP_PATH . "/services/AdminDocenteService.php";

class AdminDocenteController extends Controller {

  private function requireAdmin(): void {
    Auth::requireLogin();
    $u = Auth::user();
    $rol = strtoupper(trim((string)($u['rol'] ?? '')));
    if (!in_array($rol, ['ADMIN','ADMINISTRADOR'], true)) {
      http_response_code(403);
      echo "403 - No autorizado";
      exit;
    }
  }

  public function index(): void {
    $this->requireAdmin();
    $service = new AdminDocenteService();

    $this->view('admin/docentes/index', [
      'docentes' => $service->listar(),
      'ok' => $_GET['ok'] ?? '',
      'error' => $_GET['error'] ?? ''
    ]);
  }

  public function createForm(): void {
    $this->requireAdmin();
    $this->view('admin/docentes/create', [
      'error' => $_GET['error'] ?? ''
    ]);
  }

  public function store(): void {
    $this->requireAdmin();

    try {
      $service = new AdminDocenteService();
      $service->registrar($_POST);

      $this->redirect('/SEIR/public/admin/docentes?ok=' . urlencode('Docente registrado.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/docentes/crear?error=' . urlencode($e->getMessage()));
    }
  }

  public function editForm(): void {
    $this->requireAdmin();

    $id = (int)($_GET['id'] ?? 0);
    if ($id <= 0) {
      $this->redirect('/SEIR/public/admin/docentes?error=' . urlencode('Docente inválido.'));
    }

    $service = new AdminDocenteService();
    $docente = $service->buscar($id);
    if (!$docente) {
      $this->redirect('/SEIR/public/admin/docentes?error=' . urlencode('Docente no encontrado.'));
    }

    $this->view('admin/docentes/edit', [
      'docente' => $docente,
      'error' => $_GET['error'] ?? ''
    ]);
  }

  public function update(): void {
    $this->requireAdmin();

    try {
      $service = new AdminDocenteService();
      $service->actualizar($_POST);
      $this->redirect('/SEIR/public/admin/docentes?ok=' . urlencode('Docente actualizado.'));
    } catch (Throwable $e) {
      $id = (int)($_POST['id_usuario'] ?? 0);
      $this->redirect('/SEIR/public/admin/docentes/editar?id=' . $id . '&error=' . urlencode($e->getMessage()));
    }
  }

  public function toggleEstado(): void {
    $this->requireAdmin();

    try {
      $id = (int)($_POST['id_usuario'] ?? 0);
      $estado = (string)($_POST['estado'] ?? '');
      $service = new AdminDocenteService();
      $service->cambiarEstado($id, $estado);
      $this->redirect('/SEIR/public/admin/docentes?ok=' . urlencode('Estado actualizado.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/docentes?error=' . urlencode($e->getMessage()));
    }
  }

  public function resetPassword(): void {
    $this->requireAdmin();

    try {
      $id = (int)($_POST['id_usuario'] ?? 0);
      $newPass = trim((string)($_POST['nueva_clave'] ?? ''));

      $service = new AdminDocenteService();
      $pass = $service->resetearClave($id, $newPass);

      $this->redirect('/SEIR/public/admin/docentes?ok=' . urlencode('Clave reseteada. Nueva clave: ' . $pass));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/docentes?error=' . urlencode($e->getMessage()));
    }
  }

  public function delete(): void {
    $this->requireAdmin();
    try {
      $id = (int)($_POST['id_usuario'] ?? 0);
      $service = new AdminDocenteService();
      $service->eliminar($id);
      $this->redirect('/SEIR/public/admin/docentes?ok=' . urlencode('Docente eliminado.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/docentes?error=' . urlencode($e->getMessage()));
    }
  }

  public function destroy(): void {
    $this->requireAdmin();

    try {
      $id = (int)($_POST['id_usuario'] ?? 0);
      $service = new AdminDocenteService();
      $service->eliminar($id);
      $this->redirect('/SEIR/public/admin/docentes?ok=' . urlencode('Docente eliminado.'));
    } catch (Throwable $e) {
      $this->redirect('/SEIR/public/admin/docentes?error=' . urlencode($e->getMessage()));
    }
  }
}
